/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.formats.binary;

import de.pauleff.formats.binary.Compression_Types;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;

public class NBTFileHandler {
    public static DataInputStream loadNBTToReader(File file) throws IOException {
        if (Files.notExists(file.toPath(), new LinkOption[0])) {
            throw new FileNotFoundException(String.format("The file %s doesn't exist!", file.getPath()));
        }
        return new DataInputStream(switch (NBTFileHandler.getCompressionType(file)) {
            case Compression_Types.NONE -> {
                System.out.printf("The file %s was uncompressed.%n", file.getName(), Compression_Types.GZIP.getName());
                yield new FileInputStream(file);
            }
            case Compression_Types.GZIP -> {
                System.out.printf("The file %s was compressed with %s, decompressing...%n", file.getName(), Compression_Types.GZIP.getName());
                yield new GZIPInputStream(new FileInputStream(file));
            }
            case Compression_Types.ZLIB -> {
                System.out.printf("The file %s was compressed with %s, decompressing...%n", file.getName(), Compression_Types.ZLIB.getName());
                yield new InflaterInputStream(new FileInputStream(file));
            }
            default -> throw new IllegalArgumentException(String.format("The file %s is compressed with an unsupported format!", file.getName()));
        });
    }

    public static DataOutputStream loadNBTToWriter(File file, Compression_Types compression) throws IOException {
        if (Files.exists(file.toPath(), new LinkOption[0])) {
            File backupFile = new File(file.getPath() + ".bak");
            try {
                Files.copy(file.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                System.out.printf("Created backup of file %s -> %s%n", file.getName(), backupFile.getName());
            }
            catch (IOException e) {
                throw new IOException("Failed to create backup file: " + e.getMessage(), e);
            }
        }
        return new DataOutputStream(switch (compression) {
            case Compression_Types.NONE -> {
                System.out.printf("Compression type for writing %s set to %s%n", file.getName(), Compression_Types.NONE.getName());
                yield new FileOutputStream(file);
            }
            case Compression_Types.GZIP -> {
                System.out.printf("Compression type for writing %s set to %s%n", file.getName(), Compression_Types.GZIP.getName());
                yield new GZIPOutputStream(new FileOutputStream(file));
            }
            case Compression_Types.ZLIB -> {
                System.out.printf("Compression type for writing %s set to %s%n", file.getName(), Compression_Types.ZLIB.getName());
                yield new DeflaterOutputStream(new FileOutputStream(file));
            }
            default -> throw new IllegalArgumentException(String.format("The compression type %s is not supported!", new Object[]{compression}));
        });
    }

    public static Compression_Types getCompressionType(File file) {
        if (NBTFileHandler.isGzipped(file)) {
            return Compression_Types.GZIP;
        }
        if (NBTFileHandler.isZlibed(file)) {
            return Compression_Types.ZLIB;
        }
        if (NBTFileHandler.isLZ4ed(file)) {
            return Compression_Types.LZ4;
        }
        return Compression_Types.NONE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isGzipped(File file) {
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            if (raf.length() < 2L) {
                boolean bl = false;
                return bl;
            }
            int magic = raf.read() & 0xFF | raf.read() << 8 & 0xFF00;
            boolean bl = magic == 35615;
            return bl;
        }
        catch (IOException e) {
            System.err.printf("Warning: Could not check GZIP magic for file %s: %s%n", file.getName(), e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isZlibed(File file) {
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            if (raf.length() < 2L) {
                boolean bl = false;
                return bl;
            }
            byte[] header = new byte[2];
            raf.readFully(header);
            int headerValue = (header[0] & 0xFF) << 8 | header[1] & 0xFF;
            if (headerValue % 31 != 0) {
                boolean bl = false;
                return bl;
            }
            int compressionMethod = header[0] & 0xF;
            boolean bl = compressionMethod == 8;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isLZ4ed(File file) {
        return false;
    }
}

