/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.formats.binary;

import de.pauleff.api.ICompoundTag;
import de.pauleff.api.INBTReader;
import de.pauleff.core.Tag;
import de.pauleff.core.Tag_Compound;
import de.pauleff.formats.binary.NBTFileHandler;
import de.pauleff.formats.binary.PositionTrackingDataInputStream;
import de.pauleff.util.NBTTags;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class NBTReader
implements INBTReader {
    private final PositionTrackingDataInputStream stream;

    public NBTReader(File nbtFile) {
        try {
            DataInputStream baseStream = NBTFileHandler.loadNBTToReader(nbtFile);
            this.stream = new PositionTrackingDataInputStream(baseStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize NBT reader for file: " + nbtFile.getAbsolutePath(), e);
        }
    }

    public NBTReader(DataInputStream dis) {
        this.stream = new PositionTrackingDataInputStream(dis);
    }

    public static PositionTrackingDataInputStream byteArrayToDataInputStream(byte[] chunkData) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(chunkData);
        return new PositionTrackingDataInputStream(byteArrayInputStream);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public ICompoundTag read() throws IOException {
        try {
            Tag_Compound tag;
            Tag_Compound tag_Compound = tag = (Tag_Compound)this.readNBTTag(0);
            return tag_Compound;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to parse NBT data: " + e.getMessage(), e);
        }
        finally {
            this.close();
        }
    }

    private Tag readNBTTag(int depth) throws IOException {
        try {
            byte type = this.stream.readByte();
            String name = "";
            if (type != NBTTags.Tag_End.getId()) {
                int nameLength = this.stream.readUnsignedShort();
                if (nameLength < 0 || nameLength > Short.MAX_VALUE) {
                    throw new IOException(this.stream.createContextualError(String.format("Invalid tag name length: %d", nameLength)));
                }
                byte[] byteBuffer = new byte[nameLength];
                this.stream.readFully(byteBuffer);
                name = new String(byteBuffer, StandardCharsets.UTF_8);
            }
            this.stream.setCurrentContext(depth, name, type);
            return this.readNBTPayload(type, name, depth);
        }
        catch (IOException e) {
            if (e.getMessage().contains("[Position:")) {
                throw e;
            }
            throw new IOException(this.stream.createContextualError("Failed to read NBT tag: " + e.getMessage()), e);
        }
    }

    /*
     * Exception decompiling
     */
    private Tag readNBTPayload(int type, String name, int depth) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=5,325
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

