/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.formats.binary;

import de.pauleff.api.ICompoundTag;
import de.pauleff.api.INBTWriter;
import de.pauleff.api.ITag;
import de.pauleff.formats.binary.Compression_Types;
import de.pauleff.formats.binary.NBTFileHandler;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class NBTWriter
implements INBTWriter {
    private final DataOutputStream stream;

    public NBTWriter(File nbtFile) throws FileNotFoundException {
        if (Files.notExists(nbtFile.toPath(), new LinkOption[0])) {
            throw new FileNotFoundException(String.format("The file %s doesn't exist. It's needed to determine the compression type!", nbtFile.getPath()));
        }
        try {
            this.stream = NBTFileHandler.loadNBTToWriter(nbtFile, NBTFileHandler.getCompressionType(nbtFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NBTWriter(File nbtFile, Compression_Types compression) {
        try {
            this.stream = NBTFileHandler.loadNBTToWriter(nbtFile, compression);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NBTWriter(DataOutputStream dos) {
        this.stream = dos;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void write(ICompoundTag root) throws IOException {
        if (root == null) {
            throw new IllegalArgumentException("Root compound tag cannot be null");
        }
        try {
            this.writeNBTTag(root);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to write NBT data: " + e.getMessage(), e);
        }
        finally {
            this.close();
        }
    }

    private void writeNBTTag(ITag<?> tag) throws IOException {
        String name = tag.getName();
        byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
        this.stream.writeByte(tag.getId());
        this.stream.writeShort(nameBytes.length);
        this.stream.write(nameBytes);
        this.writeNBTPayload(tag);
    }

    /*
     * Exception decompiling
     */
    private void writeNBTPayload(ITag<?> tag) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=3,273
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

