/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.formats.binary;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PositionTrackingDataInputStream {
    private final DataInputStream dataStream;
    private long bytesRead;
    private int tagDepth;
    private String currentTagName;
    private int currentTagType;

    public PositionTrackingDataInputStream(InputStream in) {
        this.dataStream = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        this.bytesRead = 0L;
        this.tagDepth = 0;
        this.currentTagName = "";
        this.currentTagType = -1;
    }

    public void readFully(byte[] b) throws IOException {
        this.dataStream.readFully(b);
        this.bytesRead += (long)b.length;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dataStream.readFully(b, off, len);
        this.bytesRead += (long)len;
    }

    public byte readByte() throws IOException {
        byte result = this.dataStream.readByte();
        ++this.bytesRead;
        return result;
    }

    public int readUnsignedByte() throws IOException {
        int result = this.dataStream.readUnsignedByte();
        ++this.bytesRead;
        return result;
    }

    public short readShort() throws IOException {
        short result = this.dataStream.readShort();
        this.bytesRead += 2L;
        return result;
    }

    public int readUnsignedShort() throws IOException {
        int result = this.dataStream.readUnsignedShort();
        this.bytesRead += 2L;
        return result;
    }

    public int readInt() throws IOException {
        int result = this.dataStream.readInt();
        this.bytesRead += 4L;
        return result;
    }

    public long readLong() throws IOException {
        long result = this.dataStream.readLong();
        this.bytesRead += 8L;
        return result;
    }

    public float readFloat() throws IOException {
        float result = this.dataStream.readFloat();
        this.bytesRead += 4L;
        return result;
    }

    public double readDouble() throws IOException {
        double result = this.dataStream.readDouble();
        this.bytesRead += 8L;
        return result;
    }

    public void close() throws IOException {
        this.dataStream.close();
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public int getTagDepth() {
        return this.tagDepth;
    }

    public void setCurrentContext(int depth, String tagName, int tagType) {
        this.tagDepth = depth;
        this.currentTagName = tagName;
        this.currentTagType = tagType;
    }

    public String createContextualError(String baseMessage) {
        StringBuilder error = new StringBuilder(baseMessage);
        error.append(String.format(" [Position: %d bytes", this.bytesRead));
        if (this.tagDepth > 0) {
            error.append(String.format(", Depth: %d", this.tagDepth));
        }
        if (!this.currentTagName.isEmpty()) {
            error.append(String.format(", Tag: '%s'", this.currentTagName));
        }
        if (this.currentTagType >= 0) {
            error.append(String.format(", Type: %d", this.currentTagType));
        }
        error.append("]");
        return error.toString();
    }
}

