/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.formats.snbt;

public class SNBTException
extends Exception {
    private final int position;
    private final String input;

    public SNBTException(String message) {
        super(message);
        this.position = -1;
        this.input = null;
    }

    public SNBTException(String message, int position, String input) {
        super(SNBTException.formatMessage(message, position, input));
        this.position = position;
        this.input = input;
    }

    public SNBTException(String message, Throwable cause) {
        super(message, cause);
        this.position = -1;
        this.input = null;
    }

    public SNBTException(String message, int position, String input, Throwable cause) {
        super(SNBTException.formatMessage(message, position, input), cause);
        this.position = position;
        this.input = input;
    }

    private static String formatMessage(String message, int position, String input) {
        if (position < 0 || input == null) {
            return message;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append(" at position ").append(position);
        if (position < input.length()) {
            sb.append(" (near '").append(input.charAt(position)).append("')");
        }
        return sb.toString();
    }

    public int getPosition() {
        return this.position;
    }

    public String getInput() {
        return this.input;
    }
}

