/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.formats.snbt;

import de.pauleff.api.ICompoundTag;
import de.pauleff.api.IListTag;
import de.pauleff.api.ITag;
import de.pauleff.api.NBTFactory;
import de.pauleff.core.Collection_Tag;
import de.pauleff.formats.snbt.SNBTException;
import de.pauleff.formats.snbt.SNBTTokenizer;
import de.pauleff.util.NBTTags;
import java.util.ArrayList;

public class SNBTParser {
    private final SNBTTokenizer tokenizer;
    private SNBTTokenizer.Token currentToken;

    public SNBTParser(String input) {
        this.tokenizer = new SNBTTokenizer(input);
    }

    public ITag<?> parse() throws SNBTException {
        this.advance();
        ITag<?> result = this.parseValue();
        if (this.currentToken.getType() != SNBTTokenizer.TokenType.EOF) {
            throw new SNBTException("Unexpected token after parsing completed", this.currentToken.getPosition(), this.tokenizer.getInput());
        }
        return result;
    }

    private ITag<?> parseValue() throws SNBTException {
        switch (this.currentToken.getType()) {
            case LBRACE: {
                return this.parseCompound();
            }
            case LBRACKET: {
                return this.parseListOrArray();
            }
            case STRING: {
                return this.parseStringValue();
            }
            case NUMBER: {
                return this.parseNumber();
            }
        }
        throw new SNBTException("Unexpected token: " + String.valueOf((Object)this.currentToken.getType()), this.currentToken.getPosition(), this.tokenizer.getInput());
    }

    private ICompoundTag parseCompound() throws SNBTException {
        this.expect(SNBTTokenizer.TokenType.LBRACE);
        ICompoundTag compound = NBTFactory.createCompound();
        if (this.currentToken.getType() == SNBTTokenizer.TokenType.RBRACE) {
            this.advance();
            return compound;
        }
        do {
            if (this.currentToken.getType() != SNBTTokenizer.TokenType.STRING) {
                throw new SNBTException("Expected string key in compound", this.currentToken.getPosition(), this.tokenizer.getInput());
            }
            String key = this.currentToken.getValue();
            this.advance();
            this.expect(SNBTTokenizer.TokenType.COLON);
            ITag<?> value = this.parseValue();
            value.setName(key);
            ((Collection_Tag)((Object)compound)).addTag(value);
            if (this.currentToken.getType() != SNBTTokenizer.TokenType.COMMA) {
                if (this.currentToken.getType() == SNBTTokenizer.TokenType.RBRACE) break;
                throw new SNBTException("Expected ',' or '}' in compound", this.currentToken.getPosition(), this.tokenizer.getInput());
            }
            this.advance();
        } while (this.currentToken.getType() != SNBTTokenizer.TokenType.RBRACE);
        this.expect(SNBTTokenizer.TokenType.RBRACE);
        return compound;
    }

    private ITag<?> parseListOrArray() throws SNBTException {
        this.expect(SNBTTokenizer.TokenType.LBRACKET);
        if (this.currentToken.getType() == SNBTTokenizer.TokenType.ARRAY_PREFIX) {
            return this.parseArray();
        }
        return this.parseList();
    }

    private ITag<?> parseArray() throws SNBTException {
        String prefix = this.currentToken.getValue();
        this.advance();
        this.expect(SNBTTokenizer.TokenType.SEMICOLON);
        switch (prefix) {
            case "B": {
                return this.parseByteArray();
            }
            case "I": {
                return this.parseIntArray();
            }
            case "L": {
                return this.parseLongArray();
            }
        }
        throw new SNBTException("Unknown array prefix: " + prefix, this.currentToken.getPosition(), this.tokenizer.getInput());
    }

    private ITag<byte[]> parseByteArray() throws SNBTException {
        ArrayList<Byte> values = new ArrayList<Byte>();
        if (this.currentToken.getType() == SNBTTokenizer.TokenType.RBRACKET) {
            this.advance();
            return NBTFactory.createByteArray("", new byte[0]);
        }
        do {
            ITag<?> value;
            if (!((value = this.parseValue()).getData() instanceof Byte)) {
                throw new SNBTException("Expected byte value in byte array", this.currentToken.getPosition(), this.tokenizer.getInput());
            }
            values.add((Byte)value.getData());
            if (this.currentToken.getType() != SNBTTokenizer.TokenType.COMMA) {
                if (this.currentToken.getType() == SNBTTokenizer.TokenType.RBRACKET) break;
                throw new SNBTException("Expected ',' or ']' in array", this.currentToken.getPosition(), this.tokenizer.getInput());
            }
            this.advance();
        } while (this.currentToken.getType() != SNBTTokenizer.TokenType.RBRACKET);
        this.expect(SNBTTokenizer.TokenType.RBRACKET);
        byte[] array = new byte[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            array[i] = (Byte)values.get(i);
        }
        return NBTFactory.createByteArray("", array);
    }

    private ITag<int[]> parseIntArray() throws SNBTException {
        ArrayList<Integer> values = new ArrayList<Integer>();
        if (this.currentToken.getType() == SNBTTokenizer.TokenType.RBRACKET) {
            this.advance();
            return NBTFactory.createIntArray("", new int[0]);
        }
        do {
            ITag<?> value;
            if (!((value = this.parseValue()).getData() instanceof Integer)) {
                throw new SNBTException("Expected int value in int array", this.currentToken.getPosition(), this.tokenizer.getInput());
            }
            values.add((Integer)value.getData());
            if (this.currentToken.getType() != SNBTTokenizer.TokenType.COMMA) {
                if (this.currentToken.getType() == SNBTTokenizer.TokenType.RBRACKET) break;
                throw new SNBTException("Expected ',' or ']' in array", this.currentToken.getPosition(), this.tokenizer.getInput());
            }
            this.advance();
        } while (this.currentToken.getType() != SNBTTokenizer.TokenType.RBRACKET);
        this.expect(SNBTTokenizer.TokenType.RBRACKET);
        int[] array = new int[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            array[i] = (Integer)values.get(i);
        }
        return NBTFactory.createIntArray("", array);
    }

    private ITag<long[]> parseLongArray() throws SNBTException {
        ArrayList<Long> values = new ArrayList<Long>();
        if (this.currentToken.getType() == SNBTTokenizer.TokenType.RBRACKET) {
            this.advance();
            return NBTFactory.createLongArray("", new long[0]);
        }
        do {
            ITag<?> value;
            if (!((value = this.parseValue()).getData() instanceof Long)) {
                throw new SNBTException("Expected long value in long array", this.currentToken.getPosition(), this.tokenizer.getInput());
            }
            values.add((Long)value.getData());
            if (this.currentToken.getType() != SNBTTokenizer.TokenType.COMMA) {
                if (this.currentToken.getType() == SNBTTokenizer.TokenType.RBRACKET) break;
                throw new SNBTException("Expected ',' or ']' in array", this.currentToken.getPosition(), this.tokenizer.getInput());
            }
            this.advance();
        } while (this.currentToken.getType() != SNBTTokenizer.TokenType.RBRACKET);
        this.expect(SNBTTokenizer.TokenType.RBRACKET);
        long[] array = new long[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            array[i] = (Long)values.get(i);
        }
        return NBTFactory.createLongArray("", array);
    }

    private IListTag parseList() throws SNBTException {
        ArrayList values = new ArrayList();
        if (this.currentToken.getType() == SNBTTokenizer.TokenType.RBRACKET) {
            this.advance();
            return NBTFactory.createList("", NBTTags.Tag_Compound.getId());
        }
        ITag<?> firstValue = this.parseValue();
        values.add(firstValue);
        int listType = this.getTagTypeId(firstValue);
        while (this.currentToken.getType() == SNBTTokenizer.TokenType.COMMA) {
            this.advance();
            if (this.currentToken.getType() == SNBTTokenizer.TokenType.RBRACKET) break;
            ITag<?> value = this.parseValue();
            int valueType = this.getTagTypeId(value);
            if (valueType != listType) {
                throw new SNBTException("Mixed types in list not allowed. Expected type " + listType + " but got " + valueType, this.currentToken.getPosition(), this.tokenizer.getInput());
            }
            values.add(value);
        }
        this.expect(SNBTTokenizer.TokenType.RBRACKET);
        IListTag list = NBTFactory.createList("", listType);
        for (ITag iTag : values) {
            ((Collection_Tag)((Object)list)).addTag(iTag);
        }
        return list;
    }

    private ITag<?> parseStringValue() throws SNBTException {
        String value = this.currentToken.getValue();
        this.advance();
        if ("true".equals(value)) {
            return NBTFactory.createByte("", (byte)1);
        }
        if ("false".equals(value)) {
            return NBTFactory.createByte("", (byte)0);
        }
        return NBTFactory.createString("", value);
    }

    private ITag<?> parseNumber() throws SNBTException {
        String numberStr = this.currentToken.getValue();
        this.advance();
        try {
            char lastChar = numberStr.charAt(numberStr.length() - 1);
            if (Character.isLetter(lastChar)) {
                String numPart = numberStr.substring(0, numberStr.length() - 1);
                char suffix = Character.toLowerCase(lastChar);
                switch (suffix) {
                    case 'b': {
                        return NBTFactory.createByte("", Byte.parseByte(numPart));
                    }
                    case 's': {
                        return NBTFactory.createShort("", Short.parseShort(numPart));
                    }
                    case 'l': {
                        return NBTFactory.createLong("", Long.parseLong(numPart));
                    }
                    case 'f': {
                        return NBTFactory.createFloat("", Float.parseFloat(numPart));
                    }
                    case 'd': {
                        return NBTFactory.createDouble("", Double.parseDouble(numPart));
                    }
                }
                throw new SNBTException("Unknown numeric suffix: " + suffix, this.currentToken.getPosition(), this.tokenizer.getInput());
            }
            if (numberStr.contains(".")) {
                return NBTFactory.createDouble("", Double.parseDouble(numberStr));
            }
            return NBTFactory.createInt("", Integer.parseInt(numberStr));
        }
        catch (NumberFormatException e) {
            throw new SNBTException("Invalid number format: " + numberStr, this.currentToken.getPosition(), this.tokenizer.getInput(), e);
        }
    }

    private int getTagTypeId(ITag<?> tag) {
        Object value = tag.getData();
        if (value instanceof Byte) {
            return NBTTags.Tag_Byte.getId();
        }
        if (value instanceof Short) {
            return NBTTags.Tag_Short.getId();
        }
        if (value instanceof Integer) {
            return NBTTags.Tag_Int.getId();
        }
        if (value instanceof Long) {
            return NBTTags.Tag_Long.getId();
        }
        if (value instanceof Float) {
            return NBTTags.Tag_Float.getId();
        }
        if (value instanceof Double) {
            return NBTTags.Tag_Double.getId();
        }
        if (value instanceof String) {
            return NBTTags.Tag_String.getId();
        }
        if (value instanceof byte[]) {
            return NBTTags.Tag_Byte_Array.getId();
        }
        if (value instanceof int[]) {
            return NBTTags.Tag_Int_Array.getId();
        }
        if (value instanceof long[]) {
            return NBTTags.Tag_Long_Array.getId();
        }
        if (tag instanceof IListTag) {
            return NBTTags.Tag_List.getId();
        }
        if (tag instanceof ICompoundTag) {
            return NBTTags.Tag_Compound.getId();
        }
        return NBTTags.Tag_End.getId();
    }

    private void advance() throws SNBTException {
        this.currentToken = this.tokenizer.nextToken();
    }

    private void expect(SNBTTokenizer.TokenType expectedType) throws SNBTException {
        if (this.currentToken.getType() != expectedType) {
            throw new SNBTException("Expected " + String.valueOf((Object)expectedType) + " but got " + String.valueOf((Object)this.currentToken.getType()), this.currentToken.getPosition(), this.tokenizer.getInput());
        }
        this.advance();
    }
}

