/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.formats.snbt;

import de.pauleff.api.ICompoundTag;
import de.pauleff.api.IListTag;
import de.pauleff.api.ITag;
import de.pauleff.core.Tag;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class SNBTSerializer {
    private static final boolean SPACES_AROUND_COLON = true;
    private static final boolean SPACES_IN_COMPOUNDS = true;
    private static final boolean SPACES_IN_LISTS = true;
    private static final boolean SPACES_IN_ARRAYS = false;
    private static final boolean EXPLICIT_DOUBLE_TYPE = false;
    private static final boolean ADD_TRAILING_NEWLINE = true;
    private static final boolean ALWAYS_QUOTE_STRINGS = false;

    public String serialize(ITag<?> tag) {
        if (tag == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        this.serializeTag(tag, sb, 0);
        return sb.toString();
    }

    public void writeToFile(ITag<?> tag, File file) throws IOException {
        String snbt = this.serialize(tag);
        try (FileWriter writer = new FileWriter(file);){
            writer.write(snbt);
            writer.write(System.lineSeparator());
        }
    }

    private void serializeTag(ITag<?> tag, StringBuilder sb, int depth) {
        if (tag instanceof ICompoundTag) {
            this.serializeCompound((ICompoundTag)tag, sb, depth);
        } else if (tag instanceof IListTag) {
            this.serializeList((IListTag)tag, sb, depth);
        } else {
            Object data = tag.getData();
            int tagId = tag.getId();
            switch (tagId) {
                case 1: {
                    if (data instanceof Byte) {
                        this.serializeByte((Byte)data, sb);
                        break;
                    }
                    sb.append("\"invalid_byte\"");
                    break;
                }
                case 2: {
                    if (data instanceof Short) {
                        this.serializeShort((Short)data, sb);
                        break;
                    }
                    sb.append("\"invalid_short\"");
                    break;
                }
                case 3: {
                    if (data instanceof Integer) {
                        this.serializeInt((Integer)data, sb);
                        break;
                    }
                    sb.append("\"invalid_int\"");
                    break;
                }
                case 4: {
                    if (data instanceof Long) {
                        this.serializeLong((Long)data, sb);
                        break;
                    }
                    sb.append("\"invalid_long\"");
                    break;
                }
                case 5: {
                    if (data instanceof Float) {
                        this.serializeFloat((Float)data, sb);
                        break;
                    }
                    sb.append("\"invalid_float\"");
                    break;
                }
                case 6: {
                    if (data instanceof Double) {
                        this.serializeDouble((Double)data, sb);
                        break;
                    }
                    sb.append("\"invalid_double\"");
                    break;
                }
                case 7: {
                    if (data instanceof byte[]) {
                        this.serializeByteArray((byte[])data, sb);
                        break;
                    }
                    sb.append("\"invalid_byte_array\"");
                    break;
                }
                case 8: {
                    this.serializeString((String)data, sb);
                    break;
                }
                case 11: {
                    if (data instanceof int[]) {
                        this.serializeIntArray((int[])data, sb);
                        break;
                    }
                    sb.append("\"invalid_int_array\"");
                    break;
                }
                case 12: {
                    if (data instanceof long[]) {
                        this.serializeLongArray((long[])data, sb);
                        break;
                    }
                    sb.append("\"invalid_long_array\"");
                    break;
                }
                default: {
                    sb.append("\"unknown_type_").append(tagId).append("\"");
                }
            }
        }
    }

    private void serializeByte(Byte value, StringBuilder sb) {
        sb.append(value).append('b');
    }

    private void serializeShort(Short value, StringBuilder sb) {
        sb.append(value).append('s');
    }

    private void serializeInt(Integer value, StringBuilder sb) {
        sb.append(value);
    }

    private void serializeLong(Long value, StringBuilder sb) {
        sb.append(value).append('l');
    }

    private void serializeFloat(Float value, StringBuilder sb) {
        if (Float.isNaN(value.floatValue())) {
            sb.append("NaNf");
        } else if (Float.isInfinite(value.floatValue())) {
            sb.append(value.floatValue() > 0.0f ? "Infinityf" : "-Infinityf");
        } else {
            sb.append(value).append('f');
        }
    }

    private void serializeDouble(Double value, StringBuilder sb) {
        if (Double.isNaN(value)) {
            sb.append("NaN");
        } else if (Double.isInfinite(value)) {
            sb.append(value > 0.0 ? "Infinity" : "-Infinity");
        } else {
            sb.append(value);
        }
    }

    private void serializeString(String value, StringBuilder sb) {
        if (value == null) {
            sb.append("\"\"");
            return;
        }
        if (this.needsQuoting(value)) {
            sb.append('\"');
            this.escapeString(value, sb);
            sb.append('\"');
        } else {
            sb.append(value);
        }
    }

    private boolean needsQuoting(String value) {
        if (value.isEmpty()) {
            return true;
        }
        if (value.equals("true") || value.equals("false")) {
            return true;
        }
        if (this.looksLikeNumber(value)) {
            return true;
        }
        char first = value.charAt(0);
        if (Character.isDigit(first) || first == '-' || first == '.' || first == '+') {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return true;
        }
        return false;
    }

    private boolean looksLikeNumber(String value) {
        if (value.isEmpty()) {
            return false;
        }
        char first = value.charAt(0);
        return Character.isDigit(first) || first == '-' || first == '+';
    }

    private void escapeString(String value, StringBuilder sb) {
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        sb.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
    }

    private void serializeByteArray(byte[] array, StringBuilder sb) {
        sb.append("[B;");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(array[i]).append('b');
        }
        sb.append(']');
    }

    private void serializeIntArray(int[] array, StringBuilder sb) {
        sb.append("[I;");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(array[i]);
        }
        sb.append(']');
    }

    private void serializeLongArray(long[] array, StringBuilder sb) {
        sb.append("[L;");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(array[i]).append('l');
        }
        sb.append(']');
    }

    private void serializeCompound(ICompoundTag compound, StringBuilder sb, int depth) {
        List tags = (List)compound.getData();
        sb.append('{');
        for (int i = 0; i < tags.size(); ++i) {
            if (i > 0) {
                sb.append(',');
                sb.append(' ');
            }
            Tag tag = (Tag)tags.get(i);
            this.serializeString(tag.getName(), sb);
            sb.append(':');
            sb.append(' ');
            this.serializeTag(tag, sb, depth + 1);
        }
        sb.append('}');
    }

    private void serializeList(IListTag list, StringBuilder sb, int depth) {
        List tags = (List)list.getData();
        sb.append('[');
        for (int i = 0; i < tags.size(); ++i) {
            if (i > 0) {
                sb.append(',');
                sb.append(' ');
            } else if (!tags.isEmpty()) {
                sb.append(' ');
            }
            this.serializeTag((ITag)tags.get(i), sb, depth + 1);
        }
        if (!tags.isEmpty()) {
            sb.append(' ');
        }
        sb.append(']');
    }
}

