/*
 * Decompiled with CFR 0.152.
 */
package de.pauleff.util;

public enum NBTTags {
    Tag_End(0, "Tag_End"),
    Tag_Byte(1, "Tag_Byte"),
    Tag_Short(2, "Tag_Short"),
    Tag_Int(3, "Tag_Int"),
    Tag_Long(4, "Tag_Long"),
    Tag_Float(5, "Tag_Float"),
    Tag_Double(6, "Tag_Double"),
    Tag_Byte_Array(7, "Tag_Byte_Array"),
    Tag_String(8, "Tag_String"),
    Tag_List(9, "Tag_List"),
    Tag_Compound(10, "Tag_Compound"),
    Tag_Int_Array(11, "Tag_Int_Array"),
    Tag_Long_Array(12, "Tag_Long_Array");

    private static final NBTTags[] ID_LOOKUP;
    private final int id;
    private final String name;

    private NBTTags(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static NBTTags getById(int id) {
        return id >= 0 && id < ID_LOOKUP.length ? ID_LOOKUP[id] : null;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    static {
        ID_LOOKUP = new NBTTags[13];
        NBTTags[] nBTTagsArray = NBTTags.values();
        int n = nBTTagsArray.length;
        for (int i = 0; i < n; ++i) {
            NBTTags tag;
            NBTTags.ID_LOOKUP[tag.id] = tag = nBTTagsArray[i];
        }
    }
}

