/*
 * Decompiled with CFR 0.152.
 */
package de.pawlidi.openaletheia;

import de.pawlidi.openaletheia.AletheiaContext;
import de.pawlidi.openaletheia.LicenseException;
import de.pawlidi.openaletheia.base.model.License;
import de.pawlidi.openaletheia.generator.KeyGenerator;
import de.pawlidi.openaletheia.license.LicenseHandler;
import de.pawlidi.openaletheia.utils.CipherUtils;
import de.pawlidi.openaletheia.utils.Converter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public final class Aletheia
implements Serializable {
    private LicenseHandler licenseHandler;

    public Aletheia() {
        this("MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQCto5CpWlbTBpGs3l2yuirXIZUextLE4A3WKwxyHvaaGwhoX8Yj+aCS+JP5W6aQIN3kRGxI0Q4MjxNpJQlkEyfiANStlpaSAPed5JUosHLKXAHuS6F62ilLO9S816goeQU96mmOwHFjg80DWtJp53uIhugFq7Xd86BzZeoe+FyToB0gArgGDI7q1dKTDA9ACrPTp/7f7cWgt9xGJV61QEYCDTeCcuP/o90CbrK9p6yeZUReS66/VIdQitTokFzDk9ImrF2xJHtjfKBTv/y2qW1WV6Znd4TOb8cdn9pd1QEJB0wnZUNt+IYsLeE/oFuLdTBQFg6ADfqhTVReuCMhC0nFAgMBAAECggEAM5J2H+amDQ1RbR+qgrAKk1T1Hmv9I95MHcUxcB/ELKdEywNPLVYyHBTalmBjS0GHxgmQg9wbqR1BraQDcwbBfL20bU5hsEG7SdkfeDNYFMRZCnbKIlvzkdXWbLQ8zLCNHwOlkHGV+/GkjY+HGU9YgIdZGH4UiTSX/k5RyBsKHAofe/vGW8lMpErfIc3XzSZOKntIDLWqpLlwR5hqIpJuX0plhTgpscbJYNPBeT6g/76q5LJcHJQbWtvlg6dc6C+aXJ5TIbS+/1WTm66mrHGuyR+M6OlroFDv3yrRjZy/yr8lpYQoezpI+SP0nKqTLza2gUAdY80Ezpqk1I9EhLsEgQKBgQDmvqXBTWiQt4tWJU6YawBmxqRC34tKFo1i16oKQN9USE0Ah508BLDHL9TGI+99VVkF62azb81DtRbYlCgSBGrHNwvNxu6OJEu1Qgdgd1acBH3+pw3Ue60uUA/Svp+HIl6/WbOZ4NTzTUIXu1GyviJi/QEzioCT/b17msh3mC2SJQKBgQDApNd353PP8An75nlbLI0NWKUPh12PJNfhg7nYEKC+kZaXfiw493U/JpZDmYVWK5r1gQrf49NITYnWzOSK/HDpAF+ijPPolw0AW81HwkV6i+/110rravcYsJffNsDT05orf2dhg4cu0cHL9HNGpyHGmrzPBLliwD11RO2J1ve3IQKBgQDkL2Dn2k8v3fLzDA2/eQF6obJLV5n9eHP1bWUAosq4JI/RmEsL0W+oa0q1b1Ak18QjsHlttYB+FpUzNMCzoJ6fx3Xq13GOK6Ka62M0KJAD1gVrUXTBzlSi2hXryQslrf2YqXKNF+Q/fwV/RoUyiAilb6JCgBNLRsCdfaIFcv6N6QKBgQCrhhoTOJF1Y1SAZQVImLI+X98XpH85JKTStmaSaru08gwTdtQJJMvQHptMNTTzNIAUd4EnN8K3bdJ83pHe7kXaL+r24GmLfnKlDxgH/IHASzisu7SJSAQah6GxrR6jfJSYhieWO3XxyfGzl0PMdKMuIjhaWup1cpVGBMk7IZwOAQKBgQCnd9hLJzAfpv5kgMThUhs5qth/9aK+kouvTpOvu/LULk1Rpn1sd/c+pRzfKKDYaYmyEO2UWQexuBzJQfr8UUPbv6371RRdQUKHPzFcViXIJFTyS/6LTaaQHfqiA1jVEz0Giaa19UlZFi+YFEIEIArYUYXGG6CjUjdXxGjVrc7aHA==", "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAraOQqVpW0waRrN5dsroq1yGVHsbSxOAN1isMch72mhsIaF/GI/mgkviT+VumkCDd5ERsSNEODI8TaSUJZBMn4gDUrZaWkgD3neSVKLByylwB7kuhetopSzvUvNeoKHkFPeppjsBxY4PNA1rSaed7iIboBau13fOgc2XqHvhck6AdIAK4BgyO6tXSkwwPQAqz06f+3+3FoLfcRiVetUBGAg03gnLj/6PdAm6yvaesnmVEXkuuv1SHUIrU6JBcw5PSJqxdsSR7Y3ygU7/8tqltVlemZ3eEzm/HHZ/aXdUBCQdMJ2VDbfiGLC3hP6Bbi3UwUBYOgA36oU1UXrgjIQtJxQIDAQAB");
    }

    public Aletheia(String privateKey, String publicKey) {
        this.licenseHandler = new LicenseHandler(privateKey, publicKey);
    }

    public Aletheia(String path) throws LicenseException {
        this();
        this.loadLicense(path);
    }

    public Aletheia(File licenseFile) throws LicenseException {
        this();
        this.loadLicense(licenseFile);
    }

    public Aletheia(InputStream licenseStream) throws LicenseException {
        this();
        this.loadLicense(licenseStream);
    }

    public void loadLicense(String path) throws LicenseException {
        if (StringUtils.isNotBlank((String)path)) {
            this.licenseHandler.load(path);
        }
    }

    public void loadLicense(File licenseFile) throws LicenseException {
        if (licenseFile != null) {
            this.licenseHandler.load(licenseFile);
        }
    }

    public void loadLicense(InputStream licenseStream) throws LicenseException {
        if (licenseStream != null) {
            this.licenseHandler.load(licenseStream);
        }
    }

    public void saveLicense(String path, License license) throws LicenseException {
        if (StringUtils.isNotBlank((String)path)) {
            this.saveLicense(new File(path), license);
        }
    }

    public void saveLicense(File licenseFile, License license) throws LicenseException {
        if (licenseFile != null && license != null) {
            this.licenseHandler.setLicense(license);
            this.licenseHandler.save(licenseFile.getPath());
        }
    }

    public void verifyLicense() throws LicenseException {
        AletheiaContext.instance().setLicense(this.licenseHandler.getLicense());
    }

    public void dispose() {
        this.licenseHandler.dispose();
    }

    static boolean generateKeyFiles(String rootDirectory) {
        if (StringUtils.isNotBlank((String)rootDirectory)) {
            return KeyGenerator.generateKeyFiles(rootDirectory);
        }
        return false;
    }

    static String encryptPassword(String rootDirectory, String password) {
        String privateKeyString;
        if (StringUtils.isNotEmpty((String)rootDirectory) && StringUtils.isNotEmpty((String)password) && StringUtils.isNotEmpty((String)(privateKeyString = KeyGenerator.readPrivateKeyFile(rootDirectory)))) {
            RSAPrivateKey privateKey = CipherUtils.buildPrivateKey(privateKeyString);
            byte[] encryptedData = CipherUtils.encrypt(Converter.getBytesUtf8(password), privateKey);
            try {
                password = new String(encryptedData, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return password;
    }

    static String decryptPassword(String rootDirectory, String password) {
        String publicKeyString;
        if (StringUtils.isNotEmpty((String)rootDirectory) && StringUtils.isNotEmpty((String)password) && StringUtils.isNotEmpty((String)(publicKeyString = KeyGenerator.readPublicKeyFile(rootDirectory)))) {
            RSAPublicKey publicKey = CipherUtils.buildPublicKey(publicKeyString);
            byte[] decryptedData = CipherUtils.decrypt(Converter.getBytesUtf8(password), publicKey);
            try {
                password = new String(decryptedData, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return password;
    }

    public static void main(String[] args) throws IOException {
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            String command = args[0];
            if ("1".equalsIgnoreCase(command)) {
                if (args.length > 1) {
                    Aletheia.generateKeyFiles(args[1]);
                }
            } else if ("2".equalsIgnoreCase(command)) {
                if (args.length >= 3) {
                    System.out.println(Aletheia.encryptPassword(args[1], args[2]));
                }
            } else if ("3".equalsIgnoreCase(command) && args.length >= 3) {
                System.out.println(Aletheia.decryptPassword(args[1], args[2]));
            }
        }
    }
}

