/*
 * Decompiled with CFR 0.152.
 */
package de.pawlidi.openaletheia;

import de.pawlidi.openaletheia.base.model.License;
import de.pawlidi.openaletheia.base.model.User;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class AletheiaContext
implements Serializable {
    private static volatile AletheiaContext instance = null;
    private License license;
    private Map<String, User> userBase = new HashMap<String, User>(0);

    private AletheiaContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AletheiaContext instance() {
        if (instance != null) return instance;
        Class<AletheiaContext> clazz = AletheiaContext.class;
        synchronized (AletheiaContext.class) {
            if (instance != null) return instance;
            instance = new AletheiaContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public License getLicense() {
        return this.license;
    }

    void setLicense(License license) {
        this.license = license;
        this.userBase.clear();
    }

    void addUser(List<User> users) {
        for (User user : users) {
            this.addUser(user.getUsername(), user);
        }
    }

    void addUser(String username, User user) {
        if (StringUtils.isNotEmpty((String)username) && user != null) {
            this.userBase.put(username, user);
        }
    }

    public boolean authenticate(String username, String password) {
        User user;
        if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password) && (user = this.userBase.get(username)) != null) {
            return user.verifyPassword(password);
        }
        return false;
    }
}

