/*
 * Decompiled with CFR 0.152.
 */
package de.pawlidi.openaletheia.base.model;

import de.pawlidi.openaletheia.utils.CipherUtils;
import java.io.Serializable;
import java.util.UUID;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

@XmlRootElement(name="License")
public final class User
implements Serializable {
    private static final String VALUE_SEPARATOR = "#";
    private String uuid;
    private String username;
    private String password;

    public User() {
    }

    public User(String uuid, String username, String password) {
        this.uuid = UUID.randomUUID().toString();
        this.username = username;
        this.password = password;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = CipherUtils.encryptPassword(password);
    }

    public boolean verifyPassword(String password) {
        return CipherUtils.verifyPassword(password, this.password);
    }

    public String toString() {
        return this.uuid + VALUE_SEPARATOR + this.username + VALUE_SEPARATOR + this.password;
    }

    public User toObject(String userString) {
        Object[] values;
        if (StringUtils.isNotEmpty((String)userString) && ArrayUtils.isNotEmpty((Object[])(values = StringUtils.split((String)userString, (String)VALUE_SEPARATOR))) && values.length >= 3) {
            this.uuid = values[0];
            this.username = values[1];
            this.password = values[2];
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        if (this.password == null ? other.getPassword() != null : !this.password.equals(other.getPassword())) {
            return false;
        }
        if (this.username == null ? other.getUsername() != null : !this.username.equals(other.getUsername())) {
            return false;
        }
        return !(this.uuid == null ? other.getUuid() != null : !this.uuid.equals(other.getUuid()));
    }
}

