/*
 * Decompiled with CFR 0.152.
 */
package de.pawlidi.openaletheia.generator;

import de.pawlidi.openaletheia.utils.CipherUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public final class KeyGenerator {
    public static final String KEY_FILE_EXTENSION = "key";
    public static final String PUBLIC_KEY_FILE = "public.key";
    public static final String PRIVATE_KEY_FILE = "private.key";
    public static final String KEYSPEC_FILE_EXTENSION = "keyspec";
    public static final String PUBLIC_KEYSPEC_FILE = "public.keyspec";
    public static final String PRIVATE_KEYSPEC_FILE = "private.keyspec";

    private KeyGenerator() {
    }

    public static boolean generateKeyFiles(String rootDirectory) {
        File rootDir;
        boolean successful = false;
        if (!StringUtils.isBlank((String)rootDirectory) && (rootDir = new File(rootDirectory)).exists() && rootDir.isDirectory()) {
            KeyPair keyPair = CipherUtils.generateKeyPair();
            String publicKey = CipherUtils.getPublicKey(keyPair);
            String privateKey = CipherUtils.getPrivateKey(keyPair);
            successful = KeyGenerator.createKeyFile(rootDir, publicKey, PUBLIC_KEY_FILE);
            if (!successful) {
                return successful;
            }
            successful = KeyGenerator.createKeyFile(rootDir, privateKey, PRIVATE_KEY_FILE);
        }
        return successful;
    }

    public static boolean createKeyFile(File rootDir, String key, String fileName) {
        try {
            FileUtils.writeStringToFile((File)new File(rootDir, fileName), (String)key, (String)"UTF-8");
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String readPrivateKeyFile(String directory) {
        return KeyGenerator.readKeyFile(directory, true);
    }

    public static String readPublicKeyFile(String directory) {
        return KeyGenerator.readKeyFile(directory, false);
    }

    public static String readKeyFile(String directory, boolean privateKeyFile) {
        Collection files;
        File rootDir;
        if (!StringUtils.isBlank((String)directory) && (rootDir = new File(directory)).exists() && rootDir.isDirectory() && !(files = FileUtils.listFiles((File)rootDir, (String[])new String[]{KEY_FILE_EXTENSION}, (boolean)false)).isEmpty()) {
            for (File file : files) {
                if (!file.getName().endsWith(privateKeyFile ? PRIVATE_KEY_FILE : PUBLIC_KEY_FILE)) continue;
                try {
                    return FileUtils.readFileToString((File)file, (String)"UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static boolean flushPublicKeySpec(String directory, RSAPublicKey publicKey) {
        if (StringUtils.isBlank((String)directory) || !new File(directory).isDirectory() || publicKey == null) {
            return false;
        }
        return KeyGenerator.writeKeySpec(new File(directory, PUBLIC_KEYSPEC_FILE), publicKey.getModulus(), publicKey.getPublicExponent());
    }

    public static boolean flushPrivateKeySpec(String directory, RSAPrivateKey privateKey) {
        if (StringUtils.isBlank((String)directory) || !new File(directory).isDirectory() || privateKey == null) {
            return false;
        }
        return KeyGenerator.writeKeySpec(new File(directory, PRIVATE_KEYSPEC_FILE), privateKey.getModulus(), privateKey.getPrivateExponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeKeySpec(File file, BigInteger mod, BigInteger exp) {
        boolean successful = false;
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                outputStream.writeObject(mod);
                outputStream.writeObject(exp);
                successful = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                    outputStream = null;
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return successful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSAPublicKeySpec readPublicKeySpec(String directory) {
        if (StringUtils.isBlank((String)directory) || !new File(directory).isDirectory()) {
            return null;
        }
        RSAPublicKeySpec publicKeySpec = null;
        ObjectInputStream inputStream = null;
        try {
            inputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(new File(directory, PUBLIC_KEYSPEC_FILE))));
            try {
                BigInteger m = (BigInteger)inputStream.readObject();
                BigInteger e = (BigInteger)inputStream.readObject();
                publicKeySpec = new RSAPublicKeySpec(m, e);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return publicKeySpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSAPrivateKeySpec readPrivateKeySpec(String directory) {
        if (StringUtils.isBlank((String)directory) || !new File(directory).isDirectory()) {
            return null;
        }
        RSAPrivateKeySpec privateKeySpec = null;
        ObjectInputStream inputStream = null;
        try {
            inputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(new File(directory, PRIVATE_KEYSPEC_FILE))));
            try {
                BigInteger m = (BigInteger)inputStream.readObject();
                BigInteger e = (BigInteger)inputStream.readObject();
                privateKeySpec = new RSAPrivateKeySpec(m, e);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return privateKeySpec;
    }
}

