/*
 * Decompiled with CFR 0.152.
 */
package de.pawlidi.openaletheia.license;

import de.pawlidi.openaletheia.LicenseException;
import de.pawlidi.openaletheia.base.model.License;
import de.pawlidi.openaletheia.license.LicenseProperties;
import de.pawlidi.openaletheia.utils.CipherUtils;
import de.pawlidi.openaletheia.utils.Converter;
import de.pawlidi.openaletheia.utils.PropertiesUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.interfaces.RSAPrivateKey;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

final class LicenseGenerator
implements Serializable {
    private String privateKey;
    private Properties properties = new Properties();

    public LicenseGenerator(String privateKey) {
        this.privateKey = privateKey;
    }

    public Properties generate(License license) throws LicenseException {
        this.properties.clear();
        if (!StringUtils.isBlank((String)this.privateKey)) {
            LicenseProperties.createProperties(this.properties, license);
            String signature = this.createSignature();
            PropertiesUtils.setStringProperty(this.properties, "signature", signature);
        }
        return this.properties;
    }

    private String createSignature() {
        String signature = CipherUtils.computeSignatureString(this.properties);
        RSAPrivateKey rsaPrivateKey = CipherUtils.buildPrivateKey(this.privateKey);
        byte[] encryptedSignature = CipherUtils.encrypt(Converter.toBytes(signature), rsaPrivateKey);
        signature = Converter.toString(encryptedSignature);
        return signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeLicense(String fileName, String description) throws LicenseException {
        FileOutputStream outputStream;
        if (this.properties.isEmpty()) {
            return;
        }
        try {
            outputStream = FileUtils.openOutputStream((File)new File(fileName));
        }
        catch (IOException openOutputStreamException) {
            throw new LicenseException("Could not write license information to file " + fileName);
        }
        try {
            this.properties.store(outputStream, description);
            outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void dispose() {
        this.privateKey = null;
        this.properties.clear();
        this.properties = null;
    }
}

