/*
 * Decompiled with CFR 0.152.
 */
package de.pawlidi.openaletheia.license;

import de.pawlidi.openaletheia.LicenseException;
import de.pawlidi.openaletheia.base.model.License;
import de.pawlidi.openaletheia.license.LicenseGenerator;
import de.pawlidi.openaletheia.license.LicenseLoader;
import de.pawlidi.openaletheia.utils.DateTimeUtils;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;

public final class LicenseHandler
implements Serializable {
    private LicenseGenerator generator;
    private LicenseLoader loader;
    private License license;

    public LicenseHandler(String privateKey, String publicKey) {
        this.generator = new LicenseGenerator(privateKey);
        this.loader = new LicenseLoader(publicKey);
    }

    public LicenseHandler(String privateKey, String publicKey, License license) {
        this(privateKey, publicKey);
        this.license = license;
    }

    public LicenseHandler load(String fileName) throws LicenseException {
        this.license = this.loader.loadLicense(fileName);
        if (!this.isDateValid()) {
            throw new LicenseException("License date is invalid!");
        }
        return this;
    }

    public LicenseHandler load(File licenseFile) throws LicenseException {
        this.license = this.loader.loadLicense(licenseFile);
        if (!this.isDateValid()) {
            throw new LicenseException("License date is invalid!");
        }
        return this;
    }

    public LicenseHandler load(InputStream licenseStream) throws LicenseException {
        this.license = this.loader.loadLicense(licenseStream);
        if (!this.isDateValid()) {
            throw new LicenseException("License date is invalid!");
        }
        return this;
    }

    public void save(String fileName) throws LicenseException {
        this.save(fileName, "");
    }

    public void save(String fileName, String description) throws LicenseException {
        this.generator.generate(this.license);
        this.generator.storeLicense(fileName, description);
    }

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public boolean isDateValid() {
        if (this.license.getDueDate() != null) {
            return this.license.getDueDate().isAfter(DateTimeUtils.getCurrentTime());
        }
        return false;
    }

    public void dispose() {
        this.generator.dispose();
        this.generator = null;
        this.loader.dispose();
        this.loader = null;
    }
}

