/*
 * Decompiled with CFR 0.152.
 */
package de.pawlidi.openaletheia.license;

import de.pawlidi.openaletheia.LicenseException;
import de.pawlidi.openaletheia.base.model.License;
import de.pawlidi.openaletheia.license.LicenseProperties;
import de.pawlidi.openaletheia.utils.CipherUtils;
import de.pawlidi.openaletheia.utils.Converter;
import de.pawlidi.openaletheia.utils.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.interfaces.RSAPublicKey;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

final class LicenseLoader
implements Serializable {
    private String publicKey;

    public LicenseLoader(String publicKey) {
        this.publicKey = publicKey;
    }

    public License loadLicense(String fileName) throws LicenseException {
        Properties properties = this.load(fileName);
        License license = LicenseProperties.createLicense(properties);
        return license;
    }

    public Properties load(String fileName) throws LicenseException {
        if (StringUtils.isBlank((String)fileName)) {
            throw new LicenseException("Invalid license file");
        }
        return this.load(new File(fileName));
    }

    public License loadLicense(File licenseFile) throws LicenseException {
        Properties properties = this.load(licenseFile);
        License license = LicenseProperties.createLicense(properties);
        return license;
    }

    public Properties load(File licenseFile) throws LicenseException {
        if (licenseFile == null) {
            throw new LicenseException("Invalid license file");
        }
        try {
            return this.load(FileUtils.openInputStream((File)licenseFile));
        }
        catch (IOException e) {
            throw new LicenseException("Could not load license file " + licenseFile.getName());
        }
    }

    public License loadLicense(InputStream licenseStream) throws LicenseException {
        Properties properties = this.load(licenseStream);
        License license = LicenseProperties.createLicense(properties);
        return license;
    }

    public Properties load(InputStream licenseStream) throws LicenseException {
        if (licenseStream == null) {
            throw new LicenseException("Given input stream cannot be null");
        }
        Properties properties = new Properties();
        try {
            properties.load(licenseStream);
        }
        catch (IOException e) {
            throw new LicenseException("Could not load license file");
        }
        return this.load(properties);
    }

    public Properties load(Properties properties) throws LicenseException {
        if (PropertiesUtils.isEmpty(properties)) {
            throw new LicenseException("Given properties cannot be empty or null");
        }
        if (StringUtils.isBlank((String)this.publicKey)) {
            throw new LicenseException("Given public key cannot be empty or null");
        }
        Object signature = PropertiesUtils.removeValue(properties, "signature");
        if (signature == null) {
            throw new LicenseException("Invalid license file");
        }
        String encryptedSignature = (String)signature;
        if (StringUtils.isNotEmpty((String)encryptedSignature)) {
            byte[] signatureData = Converter.toBytes(encryptedSignature);
            RSAPublicKey rsaPublicKey = CipherUtils.buildPublicKey(this.publicKey);
            byte[] decryptedSignatureData = CipherUtils.decrypt(signatureData, rsaPublicKey);
            String decryptedSignature = Converter.toString(decryptedSignatureData);
            byte[] otherSignatureData = CipherUtils.computeSignature(properties);
            String otherSignature = Converter.toString(otherSignatureData);
            if (!StringUtils.equals((String)otherSignature, (String)decryptedSignature)) {
                throw new LicenseException("License signature violation");
            }
        } else {
            throw new LicenseException("Invalid license file");
        }
        return properties;
    }

    public void dispose() {
        this.publicKey = null;
    }
}

