/*
 * Decompiled with CFR 0.152.
 */
package de.pawlidi.openaletheia.license;

import de.pawlidi.openaletheia.base.model.License;
import de.pawlidi.openaletheia.base.model.User;
import de.pawlidi.openaletheia.utils.PropertiesUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;

public abstract class LicenseProperties {
    public static final String PRODUCT = "product";
    public static final String VERSION = "version";
    public static final String CREATED = "created";
    public static final String MODIFIED = "modified";
    public static final String ADDRESS = "address";
    public static final String HOST = "host";
    public static final String MAX_USER = "max_user";
    public static final String USER = "user";
    public static final String COMPANY = "company";
    public static final String DESCRIPTION = "description";
    public static final String SIGNATURE = "signature";
    public static final String BASE = "base";
    public static final String DUE_DATE = "due_date";
    public static final String REMOTE = "remote";
    public static final String OWNER = "owner";
    public static final String OS = "os";

    public static License createLicense(Properties properties) {
        return LicenseProperties.createLicense(properties, new License(), null);
    }

    public static License createLicense(Properties properties, Properties additional) {
        return LicenseProperties.createLicense(properties, new License(), additional);
    }

    public static License createLicense(Properties properties, License license) {
        return LicenseProperties.createLicense(properties, license, null);
    }

    public static License createLicense(Properties properties, License license, Properties additional) {
        if (PropertiesUtils.isEmpty(properties) || license == null) {
            return null;
        }
        license.setProduct(PropertiesUtils.getStringProperty(properties, PRODUCT));
        license.setProductVersion(PropertiesUtils.getStringProperty(properties, VERSION));
        license.setCreated(PropertiesUtils.getDateProperty(properties, CREATED));
        license.setModified(PropertiesUtils.getDateProperty(properties, MODIFIED));
        license.setAddress(PropertiesUtils.getStringProperty(properties, ADDRESS));
        license.setMaxHost(PropertiesUtils.getLongProperty(properties, HOST));
        license.setMaxUser(PropertiesUtils.getLongProperty(properties, MAX_USER));
        license.setCompany(PropertiesUtils.getStringProperty(properties, COMPANY));
        license.setDescription(PropertiesUtils.getStringProperty(properties, DESCRIPTION));
        license.setDueDate(PropertiesUtils.getDateProperty(properties, DUE_DATE));
        license.setRemote(PropertiesUtils.getBooleanProperty(properties, REMOTE));
        license.setSignature(PropertiesUtils.getStringProperty(properties, SIGNATURE));
        license.setOwner(PropertiesUtils.getStringProperty(properties, OWNER));
        license.setOperatingSystem(PropertiesUtils.getStringProperty(properties, OS));
        List<String> userProperies = PropertiesUtils.getListProperty(properties, USER);
        if (userProperies != null && !userProperies.isEmpty()) {
            ArrayList<User> users = new ArrayList<User>(0);
            for (String userProperty : userProperies) {
                users.add(new User().toObject(userProperty));
            }
            license.setUsers(users);
        }
        if (!PropertiesUtils.isEmpty(additional)) {
            license.setProperties(additional);
        }
        return license;
    }

    public static Properties createProperties(License license) {
        return LicenseProperties.createProperties(new Properties(), license);
    }

    public static Properties createProperties(Properties properties, License license) {
        if (license == null) {
            return null;
        }
        PropertiesUtils.setStringProperty(properties, PRODUCT, license.getProduct());
        PropertiesUtils.setStringProperty(properties, VERSION, license.getProductVersion());
        PropertiesUtils.setDateProperty(properties, CREATED, license.getCreated());
        PropertiesUtils.setDateProperty(properties, MODIFIED, license.getModified());
        PropertiesUtils.setStringProperty(properties, ADDRESS, license.getAddress());
        PropertiesUtils.setObjectProperty(properties, HOST, license.getMaxHost());
        PropertiesUtils.setObjectProperty(properties, MAX_USER, license.getMaxUser());
        PropertiesUtils.setStringProperty(properties, COMPANY, license.getCompany());
        PropertiesUtils.setStringProperty(properties, DESCRIPTION, license.getDescription());
        PropertiesUtils.setStringProperty(properties, OWNER, license.getOwner());
        PropertiesUtils.setStringProperty(properties, OS, license.getOperatingSystem());
        PropertiesUtils.setDateProperty(properties, DUE_DATE, license.getDueDate());
        if (BooleanUtils.isFalse((Boolean)license.getRemote())) {
            PropertiesUtils.setObjectProperty(properties, REMOTE, license.getRemote());
        }
        ArrayList<String> users = new ArrayList<String>(0);
        for (User user : license.getUsers()) {
            users.add(user.toString());
        }
        PropertiesUtils.setListProperty(properties, USER, users);
        if (!PropertiesUtils.isEmpty(license.getProperties())) {
            properties.putAll((Map<?, ?>)license.getProperties());
        }
        return properties;
    }
}

