/*
 * Decompiled with CFR 0.152.
 */
package de.pawlidi.openaletheia.utils;

import de.pawlidi.openaletheia.utils.Converter;
import de.pawlidi.openaletheia.utils.exec.ProcessExecutor;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public final class AletheiaUtils {
    public static final String MAC_ADDRESS_REGEX = "^([[:xdigit:]]{2}){5}[[:xdigit:]]{2}$";

    private AletheiaUtils() {
    }

    public static String getMacAddress() {
        String macAddress = AletheiaUtils.getJavaNetMacAddress();
        if (macAddress == null) {
            if (SystemUtils.IS_OS_WINDOWS) {
                macAddress = AletheiaUtils.getWindowsMacAddress();
            } else if (SystemUtils.IS_OS_LINUX) {
                macAddress = AletheiaUtils.getLinuxMacAddress();
            }
            if (macAddress == null) {
                throw new RuntimeException("Cannot read MAC address in operating system");
            }
        }
        macAddress = AletheiaUtils.normalizeMacAddress(macAddress);
        return macAddress;
    }

    public static String getJavaNetMacAddress() {
        String javaMacAdress = null;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            if (ip == null) {
                return null;
            }
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                return null;
            }
            byte[] mac = network.getHardwareAddress();
            javaMacAdress = Converter.hexToString(mac);
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return javaMacAdress;
    }

    public static String getWindowsMacAddress() {
        String ipConfigResponse = AletheiaUtils.executeCommand("ipconfig", "/all");
        if (ipConfigResponse == null) {
            return null;
        }
        String localHost = AletheiaUtils.getLocalhostAddress();
        if (localHost == null) {
            return null;
        }
        String lastMacAddressCandidate = null;
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        while (tokenizer.hasMoreTokens()) {
            String candidate;
            String line = tokenizer.nextToken().trim();
            if (line.indexOf(localHost) >= 0 && lastMacAddressCandidate != null) {
                return lastMacAddressCandidate;
            }
            int colon = line.indexOf(":");
            if (colon <= 0 || !AletheiaUtils.isMacAddressCandidate(candidate = line.substring(colon + 1).trim())) continue;
            lastMacAddressCandidate = AletheiaUtils.normalizeMacAddress(candidate);
        }
        return lastMacAddressCandidate;
    }

    private static String getLocalhostAddress() {
        String localhostAdress = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (localHost != null) {
                localhostAdress = localHost.getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localhostAdress;
    }

    private static boolean isMacAddressCandidate(String macAddress) {
        if (StringUtils.isBlank((String)macAddress)) {
            return false;
        }
        return (macAddress = macAddress.trim()).matches(MAC_ADDRESS_REGEX);
    }

    public static String getLinuxMacAddress() {
        String ipConfigResponse = AletheiaUtils.executeCommand("ifconfig", new String[0]);
        if (ipConfigResponse == null && (ipConfigResponse = AletheiaUtils.executeCommand("/sbin/ifconfig", new String[0])) == null) {
            return null;
        }
        String localHost = AletheiaUtils.getLocalhostAddress();
        if (localHost == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String lastMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            boolean containsLocalHost;
            String line = tokenizer.nextToken().trim();
            boolean bl = containsLocalHost = line.indexOf(localHost) >= 0;
            if (containsLocalHost && lastMacAddress != null) {
                return lastMacAddress;
            }
            int macAddressPosition = line.indexOf("HWaddr");
            if (macAddressPosition <= 0 || !AletheiaUtils.isMacAddressCandidate(macAddressCandidate = line.substring(macAddressPosition + 6).trim())) continue;
            lastMacAddress = AletheiaUtils.normalizeMacAddress(macAddressCandidate);
        }
        return null;
    }

    public static String executeCommand(String command, String ... args) {
        return ProcessExecutor.executeCommand(command, args);
    }

    public static String normalizeMacAddress(String macAddress) {
        if (StringUtils.isNotBlank((String)macAddress) && AletheiaUtils.isMacAddressCandidate(macAddress)) {
            macAddress = macAddress.trim();
            StringBuilder addressBuilder = new StringBuilder();
            for (int i = 0; i < macAddress.length(); ++i) {
                char part = macAddress.charAt(i);
                addressBuilder.append(Character.toUpperCase(part));
                if (i % 2 != 0) continue;
                addressBuilder.append("-");
            }
            macAddress = addressBuilder.toString();
        }
        return macAddress;
    }

    public static InetAddress getLocalIpAddress() throws UnknownHostException {
        try {
            InetAddress localAddress = null;
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> ipAddresses = networkInterface.getInetAddresses();
                while (ipAddresses.hasMoreElements()) {
                    InetAddress ipAddress = ipAddresses.nextElement();
                    if (ipAddress.isLoopbackAddress()) continue;
                    if (ipAddress.isSiteLocalAddress()) {
                        return ipAddress;
                    }
                    if (localAddress != null) continue;
                    localAddress = ipAddress;
                }
            }
            if (localAddress != null) {
                return localAddress;
            }
            localAddress = InetAddress.getLocalHost();
            if (localAddress == null) {
                throw new UnknownHostException("Could not load localhost ip address");
            }
            return localAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Could not load localhost ip address " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    public static String getLocalIpAddressString() {
        try {
            return AletheiaUtils.getLocalIpAddress().getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

