/*
 * Decompiled with CFR 0.152.
 */
package de.pawlidi.openaletheia.utils;

import de.pawlidi.openaletheia.utils.Converter;
import de.pawlidi.openaletheia.utils.StringCipher;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jasypt.util.password.StrongPasswordEncryptor;

public final class CipherUtils {
    public static final String MESSAGE_DIGEST_ALGORITHM = "MD5";
    public static final String CIPHER_ALGORITHM = "RSA";
    public static final String CIPHER_EXTENDED_ALGORITHM = "RSA/ECB/PKCS1Padding";
    public static final String RANDOM_NUMBER_GENERATOR_ALGORITHM = "SHA1PRNG";

    private CipherUtils() {
    }

    public static String computeSignatureString(Properties properties) {
        byte[] signature = CipherUtils.computeSignature(properties);
        return Converter.toString(signature);
    }

    public static byte[] computeSignature(Properties properties) {
        if (properties != null && !properties.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            ArrayList<Object> keys = new ArrayList<Object>(properties.keySet());
            Collections.sort(keys);
            for (Object key : keys) {
                Object value = properties.get(key);
                if (value == null) continue;
                builder.append(key);
                builder.append("=");
                builder.append(value);
                builder.append("\n");
            }
            String pattern = builder.toString();
            if (!pattern.isEmpty()) {
                return CipherUtils.computeSignature(Converter.getBytesIso8859(pattern));
            }
        }
        return null;
    }

    public static byte[] computeSignature(byte[] data) {
        if (ArrayUtils.isNotEmpty((byte[])data)) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
                messageDigest.update(data, 0, data.length);
                return messageDigest.digest();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot compute signature for MD5 message digest algorithm", e);
            }
        }
        return null;
    }

    public static RSAPublicKey buildPublicKey(String key) {
        if (StringUtils.isNotEmpty((String)key)) {
            try {
                byte[] bytes = Converter.toBytes(key);
                KeyFactory keyFactory = KeyFactory.getInstance(CIPHER_ALGORITHM);
                X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(bytes);
                return (RSAPublicKey)keyFactory.generatePublic(pubSpec);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create RSA public key from " + key, e);
            }
        }
        return null;
    }

    public static RSAPrivateKey buildPrivateKey(String key) {
        if (StringUtils.isNotEmpty((String)key)) {
            try {
                byte[] bytes = Converter.toBytes(key);
                KeyFactory keyFactory = KeyFactory.getInstance(CIPHER_ALGORITHM);
                PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(bytes);
                return (RSAPrivateKey)keyFactory.generatePrivate(privSpec);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create RSA private key from " + key, e);
            }
        }
        return null;
    }

    public static byte[] encrypt(byte[] data, Key key) {
        if (key != null && ArrayUtils.isNotEmpty((byte[])data)) {
            try {
                Cipher rsaCipher = Cipher.getInstance(CIPHER_EXTENDED_ALGORITHM);
                rsaCipher.init(1, key);
                return rsaCipher.doFinal(data);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot encrypt, RSA error", e);
            }
        }
        return null;
    }

    public static String encryptWithAES(String data, String key) {
        if (StringUtils.isNotEmpty((String)data) && StringUtils.isNotEmpty((String)key)) {
            SecretKeySpec keySpec = new SecretKeySpec(Converter.getBytesUtf8(key), "AES");
            StringCipher cipher = new StringCipher(keySpec, "AES");
            return cipher.encrypt(data);
        }
        return null;
    }

    public static String decryptWithAES(String data, String key) {
        if (StringUtils.isNotEmpty((String)data) && StringUtils.isNotEmpty((String)key)) {
            SecretKeySpec keySpec = new SecretKeySpec(Converter.getBytesUtf8(key), "AES");
            StringCipher cipher = new StringCipher(keySpec, "AES");
            return cipher.decrypt(data);
        }
        return null;
    }

    public static byte[] decrypt(byte[] data, Key key) {
        if (key != null && ArrayUtils.isNotEmpty((byte[])data)) {
            try {
                Cipher rsaCipher = Cipher.getInstance(CIPHER_EXTENDED_ALGORITHM);
                rsaCipher.init(2, key);
                return rsaCipher.doFinal(data);
            }
            catch (Exception e1) {
                try {
                    Cipher rsaCipher = Cipher.getInstance(CIPHER_ALGORITHM);
                    rsaCipher.init(2, key);
                    return rsaCipher.doFinal(data);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Cannot decrypt, RSA error", e2);
                }
            }
        }
        return null;
    }

    public static KeyPair generateKeyPair() {
        KeyPairGenerator generator = null;
        SecureRandom secureRandom = null;
        try {
            generator = KeyPairGenerator.getInstance(CIPHER_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not generate key", e);
        }
        try {
            secureRandom = SecureRandom.getInstance(RANDOM_NUMBER_GENERATOR_ALGORITHM, "SUN");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException generalSecurityException) {
            // empty catch block
        }
        if (secureRandom == null) {
            generator.initialize(2048);
        } else {
            generator.initialize(2048, secureRandom);
        }
        return generator.generateKeyPair();
    }

    public static String getPublicKey(KeyPair keyPair) {
        if (keyPair != null && keyPair.getPublic() != null) {
            return Converter.toString(keyPair.getPublic().getEncoded());
        }
        return null;
    }

    public static String getPrivateKey(KeyPair keyPair) {
        if (keyPair != null && keyPair.getPrivate() != null) {
            return Converter.toString(keyPair.getPrivate().getEncoded());
        }
        return null;
    }

    public static String encryptPassword(String password) {
        if (StringUtils.isBlank((String)password)) {
            return null;
        }
        StrongPasswordEncryptor passwordEncryptor = new StrongPasswordEncryptor();
        return passwordEncryptor.encryptPassword(password);
    }

    public static boolean verifyPassword(String plainPassword, String encryptedPassword) {
        if (StringUtils.isBlank((String)plainPassword) || StringUtils.isBlank((String)encryptedPassword)) {
            return false;
        }
        StrongPasswordEncryptor passwordEncryptor = new StrongPasswordEncryptor();
        return passwordEncryptor.checkPassword(plainPassword, encryptedPassword);
    }
}

