/*
 * Decompiled with CFR 0.152.
 */
package de.pawlidi.openaletheia.utils;

import de.pawlidi.openaletheia.Constants;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class PropertiesUtils {
    private static final String LIST_SEPARATOR = ",";

    public static boolean isEmpty(Properties properties) {
        return properties == null || properties.isEmpty();
    }

    public static boolean isNotEmpty(Properties properties) {
        return !PropertiesUtils.isEmpty(properties);
    }

    public static void setStringProperty(Properties properties, String key, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            properties.setProperty(key, value);
        }
    }

    public static void setDateProperty(Properties properties, String key, DateTime value) {
        if (value != null) {
            properties.setProperty(key, Constants.DATE_FORMAT.print((ReadableInstant)value));
        }
    }

    public static void setObjectProperty(Properties properties, String key, Object value) {
        if (value != null) {
            properties.setProperty(key, value.toString());
        }
    }

    public static String getStringProperty(Properties properties, String key) {
        if (PropertiesUtils.isEmpty(properties) || StringUtils.isBlank((String)key)) {
            return null;
        }
        return properties.getProperty(key);
    }

    public static Object removeValue(Properties properties, String key) {
        if (PropertiesUtils.isEmpty(properties) || StringUtils.isBlank((String)key)) {
            return null;
        }
        return properties.remove(key);
    }

    public static DateTime getDateProperty(Properties properties, String key) {
        if (PropertiesUtils.isEmpty(properties) || StringUtils.isBlank((String)key)) {
            return null;
        }
        String property = properties.getProperty(key);
        if (StringUtils.isBlank((String)property)) {
            return null;
        }
        try {
            return Constants.DATE_FORMAT.parseDateTime(property);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Boolean getBooleanProperty(Properties properties, String key) {
        if (PropertiesUtils.isEmpty(properties) || StringUtils.isBlank((String)key)) {
            return null;
        }
        String property = properties.getProperty(key);
        if (property == null) {
            return null;
        }
        return BooleanUtils.toBoolean((String)property);
    }

    public static Long getLongProperty(Properties properties, String key) {
        if (PropertiesUtils.isEmpty(properties) || StringUtils.isBlank((String)key)) {
            return null;
        }
        String property = properties.getProperty(key);
        if (property == null) {
            return null;
        }
        try {
            return Long.valueOf(property);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static List<String> getListProperty(Properties properties, String key) {
        String[] values;
        if (PropertiesUtils.isEmpty(properties) || StringUtils.isBlank((String)key)) {
            return null;
        }
        String property = PropertiesUtils.getStringProperty(properties, key);
        if (property == null) {
            return null;
        }
        ArrayList<String> listProperty = new ArrayList<String>(0);
        for (String value : values = StringUtils.split((String)property, (String)LIST_SEPARATOR)) {
            listProperty.add(value);
        }
        return listProperty;
    }

    public static void setListProperty(Properties properties, String key, List<String> values) {
        if (PropertiesUtils.isNotEmpty(properties) && StringUtils.isNotEmpty((String)key) && values != null && !values.isEmpty()) {
            int listSize = values.size();
            StringBuilder listProperty = new StringBuilder();
            for (int i = 0; i < listSize; ++i) {
                String value = values.get(i);
                if (!StringUtils.isNotEmpty((String)value)) continue;
                listProperty.append(value);
                if (i >= listSize - 1) continue;
                listProperty.append(LIST_SEPARATOR);
            }
        }
    }
}

