/*
 * Decompiled with CFR 0.152.
 */
package de.pawlidi.openaletheia.utils;

import de.pawlidi.openaletheia.utils.Converter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public final class StringCipher
implements Serializable {
    private Cipher ecipher;
    private Cipher dcipher;

    public StringCipher(SecretKey key, String algorithm) {
        try {
            this.ecipher = Cipher.getInstance(algorithm);
            this.dcipher = Cipher.getInstance(algorithm);
            this.ecipher.init(1, key);
            this.dcipher.init(2, key);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            // empty catch block
        }
    }

    public String encrypt(String data) {
        try {
            byte[] utf8 = Converter.getBytesUtf8(data);
            byte[] enc = this.ecipher.doFinal(utf8);
            return Converter.toString(enc);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            return null;
        }
    }

    public String decrypt(String data) {
        try {
            byte[] dec = Converter.toBytes(data);
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, "UTF-8");
        }
        catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException exception) {
            return null;
        }
    }
}

