/*
 * Decompiled with CFR 0.152.
 */
package de.pawlidi.openaletheia.utils.exec;

import de.pawlidi.openaletheia.utils.exec.ProcessStringOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public final class ProcessExecutor {
    public static final long WATCHDOG_TIMEOUT = 60000L;
    public static final int PROCESS_OUTPUT_LEVEL = 1;

    private ProcessExecutor() {
    }

    public static String executeCommand(String command) {
        return ProcessExecutor.executeCommand(command, new String[0]);
    }

    public static String executeCommand(String command, String ... args) {
        if (StringUtils.isNotEmpty((String)command)) {
            ProcessStringOutput processOutput = new ProcessStringOutput(1);
            Executor executor = ProcessExecutor.createExecutor((OutputStream)((Object)processOutput));
            CommandLine commandLine = new CommandLine(command);
            if (ArrayUtils.isNotEmpty((Object[])args)) {
                commandLine.addArguments(args);
            }
            int exitValue = -1;
            try {
                exitValue = executor.execute(commandLine);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!executor.isFailure(exitValue)) {
                return processOutput.getOutput();
            }
        }
        return null;
    }

    private static Executor createExecutor(OutputStream outputStream) {
        ExecuteWatchdog watchdog = new ExecuteWatchdog(60000L);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWatchdog(watchdog);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(outputStream, outputStream));
        return executor;
    }
}

