/*
 * Copyright 2022 Sascha Peilicke <sascha@peilicke.de>
 * Copyright 2016 Jeroen van Erp <jeroen@hierynomus.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package saschpe.kasn1.types

enum class ASN1TagClass(val value: UByte) {
    UNIVERSAL(0u),
    APPLICATION(0x40u),
    CONTEXT_SPECIFIC(0x80u),
    PRIVATE(0xC0u);

    companion object {
        fun parseClass(tagByte: UByte): ASN1TagClass {
            val classValue = (tagByte and 0xC0u)
            try {
                return values().first { it.value == classValue }
            } catch (e: NoSuchElementException) {
                throw IllegalStateException("Could not parse ASN.1 Tag Class (should be impossible)")
            }
        }
    }
}
