(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'ktor-ktor-io-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('ktor-ktor-io-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'Kex-kex'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'Kex-kex'.");
    }
    if (typeof this['ktor-ktor-io-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'Kex-kex'. Its dependency 'ktor-ktor-io-js-legacy' was not found. Please, check whether 'ktor-ktor-io-js-legacy' is loaded prior to 'Kex-kex'.");
    }
    root['Kex-kex'] = factory(typeof this['Kex-kex'] === 'undefined' ? {} : this['Kex-kex'], kotlin, this['ktor-ktor-io-js-legacy']);
  }
}(this, function (_, Kotlin, $module$ktor_ktor_io_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var decodeToString = Kotlin.kotlin.text.decodeToString_964n91$;
  var readBytes = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.core.readBytes_xc9h3n$;
  var writeFully = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.core.writeFully_i6snlg$;
  var Exception_init = Kotlin.kotlin.Exception_init_pdl1vj$;
  var toByte = Kotlin.toByte;
  var get_indices = Kotlin.kotlin.collections.get_indices_964n91$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var BytePacketBuilder = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.core.BytePacketBuilder_za3lpa$;
  var Throwable = Error;
  var JsMath = Math;
  var UShort_init = Kotlin.kotlin.UShort;
  var toChar = Kotlin.toChar;
  function get_hexDecoded($receiver) {
    return Hex_getInstance().toHexString_fqrh44$($receiver);
  }
  function get_hexDecodedBytes($receiver) {
    return Hex_getInstance().decode_fqrh44$($receiver);
  }
  function get_hexEncoded($receiver) {
    return decodeToString(get_hexEncodedBytes($receiver));
  }
  function get_hexEncodedBytes($receiver) {
    return Hex_getInstance().encode_fqrh44$($receiver);
  }
  function toHexString($receiver) {
    return get_hexEncoded($receiver);
  }
  function get_hexDecodedBytes_0($receiver) {
    return Hex_getInstance().decode_61zpoe$($receiver);
  }
  function Hex() {
    Hex_instance = this;
    this.encodingTable_0 = new Int8Array([toByte(48), toByte(49), toByte(50), toByte(51), toByte(52), toByte(53), toByte(54), toByte(55), toByte(56), toByte(57), toByte(97), toByte(98), toByte(99), toByte(100), toByte(101), toByte(102)]);
    this.decodingTable_0 = new Int8Array(128);
    var tmp$;
    tmp$ = get_indices(this.decodingTable_0).iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      this.decodingTable_0[element] = toByte(255);
    }
    var tmp$_0;
    tmp$_0 = get_indices(this.encodingTable_0).iterator();
    while (tmp$_0.hasNext()) {
      var element_0 = tmp$_0.next();
      this.decodingTable_0[this.encodingTable_0[element_0]] = toByte(element_0);
    }
    this.decodingTable_0[65] = this.decodingTable_0[97];
    this.decodingTable_0[66] = this.decodingTable_0[98];
    this.decodingTable_0[67] = this.decodingTable_0[99];
    this.decodingTable_0[68] = this.decodingTable_0[100];
    this.decodingTable_0[69] = this.decodingTable_0[101];
    this.decodingTable_0[70] = this.decodingTable_0[102];
  }
  Hex.prototype.toHexString_fqrh44$ = function (data) {
    return decodeToString(this.encode_fqrh44$(data));
  };
  Hex.prototype.encode_fqrh44$ = function (data) {
    var buildPacket$result;
    var builder = BytePacketBuilder(0);
    try {
      this.encodeInternal_0(data, builder);
      buildPacket$result = builder.build();
    } catch (t) {
      if (Kotlin.isType(t, Throwable)) {
        builder.release();
        throw t;
      } else
        throw t;
    }
    return readBytes(buildPacket$result);
  };
  Hex.prototype.decode_fqrh44$ = function (data) {
    var buildPacket$result;
    var builder = BytePacketBuilder(0);
    try {
      this.decodeInternal_0(data, builder);
      buildPacket$result = builder.build();
    } catch (t) {
      if (Kotlin.isType(t, Throwable)) {
        builder.release();
        throw t;
      } else
        throw t;
    }
    return readBytes(buildPacket$result);
  };
  Hex.prototype.decode_61zpoe$ = function (data) {
    var buildPacket$result;
    var builder = BytePacketBuilder(0);
    try {
      this.decodeInternal_1(data, builder);
      buildPacket$result = builder.build();
    } catch (t) {
      if (Kotlin.isType(t, Throwable)) {
        builder.release();
        throw t;
      } else
        throw t;
    }
    return readBytes(buildPacket$result);
  };
  Hex.prototype.encodeInternal_1 = function (inBuf, inOff, inLen, outBuf, outOff) {
    var tmp$, tmp$_0, tmp$_1;
    var inPos = inOff;
    var inEnd = inOff + inLen | 0;
    var outPos = outOff;
    while (inPos < inEnd) {
      var b = inBuf[tmp$ = inPos, inPos = tmp$ + 1 | 0, tmp$] & 255;
      outBuf[tmp$_0 = outPos, outPos = tmp$_0 + 1 | 0, tmp$_0] = this.encodingTable_0[b >>> 4];
      outBuf[tmp$_1 = outPos, outPos = tmp$_1 + 1 | 0, tmp$_1] = this.encodingTable_0[b & 15];
    }
    return outPos - outOff | 0;
  };
  Hex.prototype.encodeInternal_0 = function (buf, out) {
    var offM = 0;
    var lenM = buf.length;
    var tmp = new Int8Array(72);
    while (lenM > 0) {
      var b = lenM;
      var inLen = JsMath.min(36, b);
      var outLen = this.encodeInternal_1(buf, offM, inLen, tmp, 0);
      writeFully(out, tmp, 0, outLen);
      offM = offM + inLen | 0;
      lenM = lenM - inLen | 0;
    }
    return lenM * 2 | 0;
  };
  Hex.prototype.decodeInternal_0 = function (data, out) {
    var tmp$, tmp$_0, tmp$_1;
    var off = 0;
    var length = data.length;
    var b1;
    var b2;
    var outLen = 0;
    var buf = new Int8Array(36);
    var bufOff = 0;
    var end = off + length | 0;
    while (end > off && this.ignore_0(toChar((new UShort_init(data[end - 1 | 0])).data & 65535))) {
      end = end - 1 | 0;
    }
    var i = off;
    while (i < end) {
      while (true) {
        var tmp$_2 = i < end;
        if (tmp$_2) {
          tmp$_2 = this.ignore_0(toChar((new UShort_init(data[i])).data & 65535));
        }
        if (!tmp$_2)
          break;
        i = i + 1 | 0;
      }
      b1 = this.decodingTable_0[data[tmp$ = i, i = tmp$ + 1 | 0, tmp$]];
      while (true) {
        var tmp$_3 = i < end;
        if (tmp$_3) {
          tmp$_3 = this.ignore_0(toChar((new UShort_init(data[i])).data & 65535));
        }
        if (!tmp$_3)
          break;
        i = i + 1 | 0;
      }
      b2 = this.decodingTable_0[data[tmp$_0 = i, i = tmp$_0 + 1 | 0, tmp$_0]];
      if (toByte(b1 | b2) < 0) {
        throw Exception_init('invalid characters encountered in Hex data');
      }
      buf[tmp$_1 = bufOff, bufOff = tmp$_1 + 1 | 0, tmp$_1] = toByte(b1 << 4 | b2);
      if (bufOff === buf.length) {
        writeFully(out, buf, 0, buf.length);
        bufOff = 0;
      }
      outLen = outLen + 1 | 0;
    }
    if (bufOff > 0) {
      writeFully(out, buf, 0, bufOff);
    }
    return outLen;
  };
  Hex.prototype.decodeInternal_1 = function (data, out) {
    var tmp$, tmp$_0, tmp$_1;
    var b1;
    var b2;
    var length = 0;
    var buf = new Int8Array(36);
    var bufOff = 0;
    var end = data.length;
    while (end > 0 && this.ignore_0(data.charCodeAt(end - 1 | 0))) {
      end = end - 1 | 0;
    }
    var i = 0;
    while (i < end) {
      while (i < end && this.ignore_0(data.charCodeAt(i))) {
        i = i + 1 | 0;
      }
      b1 = this.decodingTable_0[data.charCodeAt((tmp$ = i, i = tmp$ + 1 | 0, tmp$)) | 0];
      while (i < end && this.ignore_0(data.charCodeAt(i))) {
        i = i + 1 | 0;
      }
      b2 = this.decodingTable_0[data.charCodeAt((tmp$_0 = i, i = tmp$_0 + 1 | 0, tmp$_0)) | 0];
      if (toByte(b1 | b2) < 0) {
        throw Exception_init('invalid characters encountered in Hex string');
      }
      buf[tmp$_1 = bufOff, bufOff = tmp$_1 + 1 | 0, tmp$_1] = toByte(b1 << 4 | b2);
      if (bufOff === buf.length) {
        writeFully(out, buf, 0, buf.length);
        bufOff = 0;
      }
      length = length + 1 | 0;
    }
    if (bufOff > 0) {
      writeFully(out, buf, 0, bufOff);
    }
    return length;
  };
  Hex.prototype.ignore_0 = function (c) {
    return c === 10 || c === 13 || c === 9 || c === 32;
  };
  Hex.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Hex',
    interfaces: []
  };
  var Hex_instance = null;
  function Hex_getInstance() {
    if (Hex_instance === null) {
      new Hex();
    }
    return Hex_instance;
  }
  var package$saschpe = _.saschpe || (_.saschpe = {});
  var package$kex = package$saschpe.kex || (package$saschpe.kex = {});
  package$kex.get_hexDecoded_964n91$ = get_hexDecoded;
  package$kex.get_hexDecodedBytes_964n91$ = get_hexDecodedBytes;
  package$kex.get_hexEncoded_964n91$ = get_hexEncoded;
  package$kex.get_hexEncodedBytes_964n91$ = get_hexEncodedBytes;
  package$kex.toHexString_964n91$ = toHexString;
  package$kex.get_hexDecodedBytes_pdl1vz$ = get_hexDecodedBytes_0;
  $$importsForInline$$['ktor-ktor-io-js-legacy'] = $module$ktor_ktor_io_js_legacy;
  Object.defineProperty(package$kex, 'Hex', {
    get: Hex_getInstance
  });
  Kotlin.defineModule('Kex-kex', _);
  return _;
}));

//# sourceMappingURL=Kex-kex.js.map
