(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'log4k'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'log4k'.");
    }root.log4k = factory(typeof log4k === 'undefined' ? {} : log4k, kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var Enum = Kotlin.kotlin.Enum;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var throwISE = Kotlin.throwISE;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var toString = Kotlin.toString;
  Log$Level.prototype = Object.create(Enum.prototype);
  Log$Level.prototype.constructor = Log$Level;
  Logger$AnsiColor.prototype = Object.create(Enum.prototype);
  Logger$AnsiColor.prototype.constructor = Logger$AnsiColor;
  ConsoleLogger.prototype = Object.create(Logger.prototype);
  ConsoleLogger.prototype.constructor = ConsoleLogger;
  function Log() {
    Log_instance = this;
    this.loggers = ArrayList_init();
  }
  function Log$Level(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Log$Level_initFields() {
    Log$Level_initFields = function () {
    };
    Log$Level$Verbose_instance = new Log$Level('Verbose', 0);
    Log$Level$Debug_instance = new Log$Level('Debug', 1);
    Log$Level$Info_instance = new Log$Level('Info', 2);
    Log$Level$Warning_instance = new Log$Level('Warning', 3);
    Log$Level$Error_instance = new Log$Level('Error', 4);
    Log$Level$Assert_instance = new Log$Level('Assert', 5);
  }
  var Log$Level$Verbose_instance;
  function Log$Level$Verbose_getInstance() {
    Log$Level_initFields();
    return Log$Level$Verbose_instance;
  }
  var Log$Level$Debug_instance;
  function Log$Level$Debug_getInstance() {
    Log$Level_initFields();
    return Log$Level$Debug_instance;
  }
  var Log$Level$Info_instance;
  function Log$Level$Info_getInstance() {
    Log$Level_initFields();
    return Log$Level$Info_instance;
  }
  var Log$Level$Warning_instance;
  function Log$Level$Warning_getInstance() {
    Log$Level_initFields();
    return Log$Level$Warning_instance;
  }
  var Log$Level$Error_instance;
  function Log$Level$Error_getInstance() {
    Log$Level_initFields();
    return Log$Level$Error_instance;
  }
  var Log$Level$Assert_instance;
  function Log$Level$Assert_getInstance() {
    Log$Level_initFields();
    return Log$Level$Assert_instance;
  }
  Log$Level.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Level',
    interfaces: [Enum]
  };
  function Log$Level$values() {
    return [Log$Level$Verbose_getInstance(), Log$Level$Debug_getInstance(), Log$Level$Info_getInstance(), Log$Level$Warning_getInstance(), Log$Level$Error_getInstance(), Log$Level$Assert_getInstance()];
  }
  Log$Level.values = Log$Level$values;
  function Log$Level$valueOf(name) {
    switch (name) {
      case 'Verbose':
        return Log$Level$Verbose_getInstance();
      case 'Debug':
        return Log$Level$Debug_getInstance();
      case 'Info':
        return Log$Level$Info_getInstance();
      case 'Warning':
        return Log$Level$Warning_getInstance();
      case 'Error':
        return Log$Level$Error_getInstance();
      case 'Assert':
        return Log$Level$Assert_getInstance();
      default:throwISE('No enum constant saschpe.log4k.Log.Level.' + name);
    }
  }
  Log$Level.valueOf_61zpoe$ = Log$Level$valueOf;
  Log.prototype.verbose_tiynjk$ = function (message, throwable, tag) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = '';
    this.log_dmm9b7$(Log$Level$Verbose_getInstance(), tag, throwable, message);
  };
  Log.prototype.info_tiynjk$ = function (message, throwable, tag) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = '';
    this.log_dmm9b7$(Log$Level$Info_getInstance(), tag, throwable, message);
  };
  Log.prototype.debug_tiynjk$ = function (message, throwable, tag) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = '';
    this.log_dmm9b7$(Log$Level$Debug_getInstance(), tag, throwable, message);
  };
  Log.prototype.warn_tiynjk$ = function (message, throwable, tag) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = '';
    this.log_dmm9b7$(Log$Level$Warning_getInstance(), tag, throwable, message);
  };
  Log.prototype.error_tiynjk$ = function (message, throwable, tag) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = '';
    this.log_dmm9b7$(Log$Level$Error_getInstance(), tag, throwable, message);
  };
  Log.prototype.assert_tiynjk$ = function (message, throwable, tag) {
    if (throwable === void 0)
      throwable = null;
    if (tag === void 0)
      tag = '';
    this.log_dmm9b7$(Log$Level$Assert_getInstance(), tag, throwable, message);
  };
  Log.prototype.log_dmm9b7$ = function (priority, tag, throwable, message) {
    if (tag === void 0)
      tag = '';
    if (throwable === void 0)
      throwable = null;
    if (message === void 0)
      message = null;
    var tmp$;
    tmp$ = this.loggers.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      element.log_w03gwz$(priority, tag, message, throwable);
    }
  };
  Log.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Log',
    interfaces: []
  };
  var Log_instance = null;
  function Log_getInstance() {
    if (Log_instance === null) {
      new Log();
    }return Log_instance;
  }
  function logged($receiver, level) {
    if (level === void 0)
      level = Log$Level$Debug_getInstance();
    Log_getInstance().log_dmm9b7$(level, void 0, void 0, $receiver.toString());
    return $receiver;
  }
  function Logger() {
    this.minimumLogLevel = Log$Level$Verbose_getInstance();
  }
  function Logger$AnsiColor(name, ordinal, value) {
    Enum.call(this);
    this.value = value;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Logger$AnsiColor_initFields() {
    Logger$AnsiColor_initFields = function () {
    };
    Logger$AnsiColor$Blue_instance = new Logger$AnsiColor('Blue', 0, '\x1B[34m');
    Logger$AnsiColor$Reset_instance = new Logger$AnsiColor('Reset', 1, '\x1B[0m');
    Logger$AnsiColor$Green_instance = new Logger$AnsiColor('Green', 2, '\x1B[32m');
    Logger$AnsiColor$Magenta_instance = new Logger$AnsiColor('Magenta', 3, '\x1B[35m');
    Logger$AnsiColor$Red_instance = new Logger$AnsiColor('Red', 4, '\x1B[31m');
    Logger$AnsiColor$White_instance = new Logger$AnsiColor('White', 5, '\x1B[37m');
    Logger$AnsiColor$Yellow_instance = new Logger$AnsiColor('Yellow', 6, '\x1B[33m');
  }
  var Logger$AnsiColor$Blue_instance;
  function Logger$AnsiColor$Blue_getInstance() {
    Logger$AnsiColor_initFields();
    return Logger$AnsiColor$Blue_instance;
  }
  var Logger$AnsiColor$Reset_instance;
  function Logger$AnsiColor$Reset_getInstance() {
    Logger$AnsiColor_initFields();
    return Logger$AnsiColor$Reset_instance;
  }
  var Logger$AnsiColor$Green_instance;
  function Logger$AnsiColor$Green_getInstance() {
    Logger$AnsiColor_initFields();
    return Logger$AnsiColor$Green_instance;
  }
  var Logger$AnsiColor$Magenta_instance;
  function Logger$AnsiColor$Magenta_getInstance() {
    Logger$AnsiColor_initFields();
    return Logger$AnsiColor$Magenta_instance;
  }
  var Logger$AnsiColor$Red_instance;
  function Logger$AnsiColor$Red_getInstance() {
    Logger$AnsiColor_initFields();
    return Logger$AnsiColor$Red_instance;
  }
  var Logger$AnsiColor$White_instance;
  function Logger$AnsiColor$White_getInstance() {
    Logger$AnsiColor_initFields();
    return Logger$AnsiColor$White_instance;
  }
  var Logger$AnsiColor$Yellow_instance;
  function Logger$AnsiColor$Yellow_getInstance() {
    Logger$AnsiColor_initFields();
    return Logger$AnsiColor$Yellow_instance;
  }
  Logger$AnsiColor.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnsiColor',
    interfaces: [Enum]
  };
  function Logger$AnsiColor$values() {
    return [Logger$AnsiColor$Blue_getInstance(), Logger$AnsiColor$Reset_getInstance(), Logger$AnsiColor$Green_getInstance(), Logger$AnsiColor$Magenta_getInstance(), Logger$AnsiColor$Red_getInstance(), Logger$AnsiColor$White_getInstance(), Logger$AnsiColor$Yellow_getInstance()];
  }
  Logger$AnsiColor.values = Logger$AnsiColor$values;
  function Logger$AnsiColor$valueOf(name) {
    switch (name) {
      case 'Blue':
        return Logger$AnsiColor$Blue_getInstance();
      case 'Reset':
        return Logger$AnsiColor$Reset_getInstance();
      case 'Green':
        return Logger$AnsiColor$Green_getInstance();
      case 'Magenta':
        return Logger$AnsiColor$Magenta_getInstance();
      case 'Red':
        return Logger$AnsiColor$Red_getInstance();
      case 'White':
        return Logger$AnsiColor$White_getInstance();
      case 'Yellow':
        return Logger$AnsiColor$Yellow_getInstance();
      default:throwISE('No enum constant saschpe.log4k.Logger.AnsiColor.' + name);
    }
  }
  Logger$AnsiColor.valueOf_61zpoe$ = Logger$AnsiColor$valueOf;
  Logger.prototype.log_w03gwz$ = function (level, tag, message, throwable) {
    if (tag === void 0)
      tag = '';
    if (level.ordinal >= this.minimumLogLevel.ordinal) {
      this.print_w03gwz$(level, tag, message, throwable);
    }};
  Logger.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Logger',
    interfaces: []
  };
  function ConsoleLogger() {
    Logger.call(this);
  }
  ConsoleLogger.prototype.print_w03gwz$ = function (level, tag, message, throwable) {
    var fullMessage = {v: toString(message)};
    if (throwable != null) {
      fullMessage.v = fullMessage.v + '\n' + toString(throwable.message);
    }switch (level.name) {
      case 'Verbose':
        console.log('Verbose ' + tag + ': ' + fullMessage.v);
        break;
      case 'Debug':
        console.log('Debug ' + tag + ': ' + fullMessage.v);
        break;
      case 'Info':
        console.info('Info ' + tag + ': ' + fullMessage.v);
        break;
      case 'Warning':
        console.warn('Warning ' + tag + ': ' + fullMessage.v);
        break;
      case 'Error':
        console.error('Error ' + tag + ': ' + fullMessage.v);
        break;
      case 'Assert':
        console.error('Assert ' + tag + ': ' + fullMessage.v);
        break;
    }
  };
  ConsoleLogger.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ConsoleLogger',
    interfaces: [Logger]
  };
  Object.defineProperty(Log$Level, 'Verbose', {
    get: Log$Level$Verbose_getInstance
  });
  Object.defineProperty(Log$Level, 'Debug', {
    get: Log$Level$Debug_getInstance
  });
  Object.defineProperty(Log$Level, 'Info', {
    get: Log$Level$Info_getInstance
  });
  Object.defineProperty(Log$Level, 'Warning', {
    get: Log$Level$Warning_getInstance
  });
  Object.defineProperty(Log$Level, 'Error', {
    get: Log$Level$Error_getInstance
  });
  Object.defineProperty(Log$Level, 'Assert', {
    get: Log$Level$Assert_getInstance
  });
  Log.prototype.Level = Log$Level;
  var package$saschpe = _.saschpe || (_.saschpe = {});
  var package$log4k = package$saschpe.log4k || (package$saschpe.log4k = {});
  Object.defineProperty(package$log4k, 'Log', {
    get: Log_getInstance
  });
  package$log4k.logged_p9c9q0$ = logged;
  Object.defineProperty(Logger$AnsiColor, 'Blue', {
    get: Logger$AnsiColor$Blue_getInstance
  });
  Object.defineProperty(Logger$AnsiColor, 'Reset', {
    get: Logger$AnsiColor$Reset_getInstance
  });
  Object.defineProperty(Logger$AnsiColor, 'Green', {
    get: Logger$AnsiColor$Green_getInstance
  });
  Object.defineProperty(Logger$AnsiColor, 'Magenta', {
    get: Logger$AnsiColor$Magenta_getInstance
  });
  Object.defineProperty(Logger$AnsiColor, 'Red', {
    get: Logger$AnsiColor$Red_getInstance
  });
  Object.defineProperty(Logger$AnsiColor, 'White', {
    get: Logger$AnsiColor$White_getInstance
  });
  Object.defineProperty(Logger$AnsiColor, 'Yellow', {
    get: Logger$AnsiColor$Yellow_getInstance
  });
  Logger.AnsiColor = Logger$AnsiColor;
  package$log4k.Logger = Logger;
  package$log4k.ConsoleLogger = ConsoleLogger;
  Kotlin.defineModule('log4k', _);
  return _;
}));

//# sourceMappingURL=log4k.js.map
