/*
 * Decompiled with CFR 0.152.
 */
package saschpe.log4k;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import saschpe.log4k.Log;
import saschpe.log4k.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0014R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\t*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lsaschpe/log4k/ConsoleLogger;", "Lsaschpe/log4k/Logger;", "()V", "javaLogger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "levelMap", "Ljava/util/HashMap;", "Lsaschpe/log4k/Log$Level;", "", "Lkotlin/collections/HashMap;", "stackTraceString", "", "getStackTraceString", "(Ljava/lang/Throwable;)Ljava/lang/String;", "getTraceTag", "trace", "Ljava/lang/StackTraceElement;", "print", "", "level", "tag", "message", "throwable", "log4k"})
public final class ConsoleLogger
extends Logger {
    private final java.util.logging.Logger javaLogger;
    @NotNull
    private final HashMap<Log.Level, String> levelMap;

    /*
     * WARNING - void declaration
     */
    public ConsoleLogger() {
        void $this$javaLogger_u24lambda_u241_u24lambda_u240;
        ConsoleHandler consoleHandler;
        void $this$javaLogger_u24lambda_u241;
        Pair[] pairArray;
        Pair[] pairArray2 = pairArray = java.util.logging.Logger.getLogger(ConsoleLogger.class.getName());
        ConsoleLogger consoleLogger = this;
        boolean bl = false;
        $this$javaLogger_u24lambda_u241.setLevel(Level.ALL);
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT %5$s %n");
        ConsoleHandler consoleHandler2 = consoleHandler = new ConsoleHandler();
        void var6_7 = $this$javaLogger_u24lambda_u241;
        boolean bl2 = false;
        $this$javaLogger_u24lambda_u241_u24lambda_u240.setLevel(Level.ALL);
        $this$javaLogger_u24lambda_u241_u24lambda_u240.setFormatter(new SimpleFormatter());
        var6_7.addHandler(consoleHandler);
        $this$javaLogger_u24lambda_u241.setUseParentHandlers(false);
        consoleLogger.javaLogger = pairArray;
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)Log.Level.Verbose), (Object)(Logger.AnsiColor.White.getValue() + "Verbose" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Debug), (Object)(Logger.AnsiColor.Blue.getValue() + "Debug" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Info), (Object)(Logger.AnsiColor.Green.getValue() + "Info" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Warning), (Object)(Logger.AnsiColor.Yellow.getValue() + "Warn" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Error), (Object)(Logger.AnsiColor.Red.getValue() + "Error" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Assert), (Object)(Logger.AnsiColor.Magenta.getValue() + "Assert" + Logger.AnsiColor.Reset.getValue()))};
        this.levelMap = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Override
    protected void print(@NotNull Log.Level level, @NotNull String tag, @Nullable String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        StackTraceElement trace = new Exception().getStackTrace()[5];
        String logTag = tag;
        if (((CharSequence)tag).length() == 0) {
            Intrinsics.checkNotNullExpressionValue((Object)trace, (String)"trace");
            logTag = this.getTraceTag(trace);
        }
        String fullMessage = null;
        fullMessage = String.valueOf(message);
        Throwable throwable2 = throwable;
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            fullMessage = fullMessage + '\n' + this.getStackTraceString(it);
        }
        String msg = this.levelMap.get((Object)level) + ' ' + logTag + ": " + fullMessage;
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                this.javaLogger.finest(msg);
                break;
            }
            case 2: {
                this.javaLogger.fine(msg);
                break;
            }
            case 3: {
                this.javaLogger.info(msg);
                break;
            }
            case 4: {
                this.javaLogger.warning(msg);
                break;
            }
            case 5: {
                this.javaLogger.severe(msg);
                break;
            }
            case 6: {
                this.javaLogger.severe(msg);
            }
        }
    }

    private final String getStackTraceString(Throwable $this$stackTraceString) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        $this$stackTraceString.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        return string;
    }

    private final String getTraceTag(StackTraceElement trace) {
        String string = trace.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trace.className");
        String[] stringArray = new String[]{"."};
        String className = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        return className + '.' + trace.getMethodName();
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Log.Level.values().length];
            try {
                nArray[Log.Level.Verbose.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Log.Level.Debug.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Log.Level.Info.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Log.Level.Warning.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Log.Level.Error.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Log.Level.Assert.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

