/*
 * Decompiled with CFR 0.152.
 */
package saschpe.log4k;

import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.Sink;
import kotlinx.io.Utf8Kt;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import kotlinx.io.files.PathsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import saschpe.log4k.FileLogger;
import saschpe.log4k.FileLogger_jvmKt;
import saschpe.log4k.Log;
import saschpe.log4k.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\u0007H\u0002J,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lsaschpe/log4k/FileLogger;", "Lsaschpe/log4k/Logger;", "rotate", "Lsaschpe/log4k/FileLogger$Rotate;", "limit", "Lsaschpe/log4k/FileLogger$Limit;", "logPath", "", "(Lsaschpe/log4k/FileLogger$Rotate;Lsaschpe/log4k/FileLogger$Limit;Ljava/lang/String;)V", "logPathInternal", "Lkotlinx/io/files/Path;", "getTraceTag", "print", "", "level", "Lsaschpe/log4k/Log$Level;", "tag", "message", "throwable", "", "Limit", "Rotate", "log4k"})
@SourceDebugExtension(value={"SMAP\nFileLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileLogger.kt\nsaschpe/log4k/FileLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class FileLogger
extends Logger {
    @NotNull
    private final Rotate rotate;
    @NotNull
    private final Limit limit;
    @Nullable
    private final String logPath;
    @NotNull
    private final Path logPathInternal;

    /*
     * WARNING - void declaration
     */
    public FileLogger(@NotNull Rotate rotate, @NotNull Limit limit, @Nullable String logPath) {
        String string;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)rotate, (String)"rotate");
                Intrinsics.checkNotNullParameter((Object)limit, (String)"limit");
                this.rotate = rotate;
                this.limit = limit;
                this.logPath = logPath;
                FileLogger fileLogger = this;
                string = this.logPath;
                if (string == null) break block2;
                String string2 = string;
                FileLogger fileLogger2 = fileLogger;
                boolean bl = false;
                Path path = PathsJvmKt.Path((String)it);
                fileLogger = fileLogger2;
                string = path;
                if (path != null) break block3;
            }
            string = FileLogger_jvmKt.getDefaultLogPath();
        }
        fileLogger.logPathInternal = string;
        FileSystem.createDirectories$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)this.logPathInternal, (boolean)false, (int)2, null);
    }

    public /* synthetic */ FileLogger(Rotate rotate, Limit limit, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            rotate = Rotate.Daily.INSTANCE;
        }
        if ((n & 2) != 0) {
            limit = new Limit.Files(10);
        }
        if ((n & 4) != 0) {
            string = null;
        }
        this(rotate, limit, string);
    }

    @Override
    protected void print(@NotNull Log.Level level, @NotNull String tag, @Nullable String message, @Nullable Throwable throwable) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        CharSequence charSequence2 = tag;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = this.getTraceTag();
        } else {
            charSequence = charSequence2;
        }
        String logTag = (String)charSequence;
        CharSequence $this$print_u24lambda_u243 = charSequence2 = CoreKt.buffered((RawSink)FileSystemJvmKt.SystemFileSystem.sink(this.rotate.logFile$log4k(this.logPathInternal), true));
        boolean bl = false;
        Utf8Kt.writeString$default((Sink)$this$print_u24lambda_u243, (String)(StringsKt.first((CharSequence)level.name()) + "/" + logTag + ": " + message), (int)0, (int)0, (int)6, null);
        Throwable throwable2 = throwable;
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl2 = false;
            Utf8Kt.writeString$default((Sink)$this$print_u24lambda_u243, (String)(" " + throwable), (int)0, (int)0, (int)6, null);
        }
        Utf8Kt.writeString$default((Sink)$this$print_u24lambda_u243, (String)"\n", (int)0, (int)0, (int)6, null);
        this.rotate.lineWritten$log4k();
        $this$print_u24lambda_u243.flush();
        this.limit.enforce$log4k(this.logPathInternal);
    }

    private final String getTraceTag() {
        Object object;
        try {
            String[] stringArray = new String[]{"\n"};
            String callSite = (String)StringsKt.split$default((CharSequence)ExceptionsKt.stackTraceToString((Throwable)new Throwable()), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(4);
            String[] stringArray2 = new String[]{" "};
            CharSequence charSequence = (CharSequence)StringsKt.split$default((CharSequence)callSite, (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(1);
            stringArray2 = new String[]{"("};
            String callSiteCleaned = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)charSequence, (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
            String[] stringArray3 = new String[]{"."};
            List kotlinPackageParts = StringsKt.split$default((CharSequence)callSiteCleaned, (String[])stringArray3, (boolean)false, (int)0, (int)6, null);
            object = kotlinPackageParts.get(kotlinPackageParts.size() - 2) + "." + CollectionsKt.last((List)kotlinPackageParts);
        }
        catch (Exception e) {
            object = "XXX";
        }
        return object;
    }

    public FileLogger() {
        this(null, null, null, 7, null);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H \u00a2\u0006\u0002\b\u0007\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lsaschpe/log4k/FileLogger$Limit;", "", "()V", "enforce", "", "logPath", "Lkotlinx/io/files/Path;", "enforce$log4k", "Files", "Not", "Lsaschpe/log4k/FileLogger$Limit$Files;", "Lsaschpe/log4k/FileLogger$Limit$Not;", "log4k"})
    public static abstract class Limit {
        private Limit() {
        }

        public abstract void enforce$log4k(@NotNull Path var1);

        public /* synthetic */ Limit(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lsaschpe/log4k/FileLogger$Limit$Files;", "Lsaschpe/log4k/FileLogger$Limit;", "max", "", "(I)V", "enforce", "", "logPath", "Lkotlinx/io/files/Path;", "enforce$log4k", "log4k"})
        public static final class Files
        extends Limit {
            private final int max;

            public Files(int max) {
                super(null);
                this.max = max;
            }

            public /* synthetic */ Files(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    n = 10;
                }
                this(n);
            }

            @Override
            public void enforce$log4k(@NotNull Path logPath) {
                Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
                FileLogger_jvmKt.limitFolderToFilesByCreationTime(logPath.toString(), this.max);
            }

            public Files() {
                this(0, 1, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0007J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Lsaschpe/log4k/FileLogger$Limit$Not;", "Lsaschpe/log4k/FileLogger$Limit;", "()V", "enforce", "", "logPath", "Lkotlinx/io/files/Path;", "enforce$log4k", "equals", "", "other", "", "hashCode", "", "toString", "", "log4k"})
        public static final class Not
        extends Limit {
            @NotNull
            public static final Not INSTANCE = new Not();

            private Not() {
                super(null);
            }

            @Override
            public void enforce$log4k(@NotNull Path logPath) {
                Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
            }

            @NotNull
            public String toString() {
                return "Not";
            }

            public int hashCode() {
                return 1847460000;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Not)) {
                    return false;
                }
                Not cfr_ignored_0 = (Not)other;
                return true;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00020\u0004H \u00a2\u0006\u0002\b\u0005J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H \u00a2\u0006\u0002\b\t\u0082\u0001\u0003\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lsaschpe/log4k/FileLogger$Rotate;", "", "()V", "lineWritten", "", "lineWritten$log4k", "logFile", "Lkotlinx/io/files/Path;", "logPath", "logFile$log4k", "After", "Daily", "Never", "Lsaschpe/log4k/FileLogger$Rotate$After;", "Lsaschpe/log4k/FileLogger$Rotate$Daily;", "Lsaschpe/log4k/FileLogger$Rotate$Never;", "log4k"})
    public static abstract class Rotate {
        private Rotate() {
        }

        @NotNull
        public abstract Path logFile$log4k(@NotNull Path var1);

        public abstract void lineWritten$log4k();

        public /* synthetic */ Rotate(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lsaschpe/log4k/FileLogger$Rotate$After;", "Lsaschpe/log4k/FileLogger$Rotate;", "lines", "", "(I)V", "dateTimeFormat", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/LocalDateTime;", "linesWritten", "lineWritten", "", "lineWritten$log4k", "logFile", "Lkotlinx/io/files/Path;", "logPath", "logFile$log4k", "log4k"})
        public static final class After
        extends Rotate {
            private final int lines;
            @NotNull
            private final DateTimeFormat<LocalDateTime> dateTimeFormat;
            private int linesWritten;

            public After(int lines) {
                super(null);
                this.lines = lines;
                this.dateTimeFormat = LocalDateTime.Companion.Format((Function1)dateTimeFormat.1.INSTANCE);
            }

            public /* synthetic */ After(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    n = 10000;
                }
                this(n);
            }

            @Override
            @NotNull
            public Path logFile$log4k(@NotNull Path logPath) {
                Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
                String[] stringArray = new String[]{"log.after_" + this.lines + ".txt"};
                Path logFile = PathsKt.Path((Path)logPath, (String[])stringArray);
                if (FileSystemJvmKt.SystemFileSystem.exists(logFile) && this.linesWritten >= this.lines) {
                    LocalDateTime now = TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()));
                    String[] stringArray2 = new String[]{"log.after_" + this.lines + "." + this.dateTimeFormat.format((Object)now) + ".txt"};
                    Path renameTo = PathsKt.Path((Path)logPath, (String[])stringArray2);
                    FileSystemJvmKt.SystemFileSystem.atomicMove(logFile, renameTo);
                    this.linesWritten = 0;
                }
                return logFile;
            }

            @Override
            public void lineWritten$log4k() {
                ++this.linesWritten;
            }

            public After() {
                this(0, 1, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\r\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000fJ\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001\u00a8\u0006\u0012"}, d2={"Lsaschpe/log4k/FileLogger$Rotate$Daily;", "Lsaschpe/log4k/FileLogger$Rotate;", "()V", "equals", "", "other", "", "hashCode", "", "lineWritten", "", "lineWritten$log4k", "logFile", "Lkotlinx/io/files/Path;", "logPath", "logFile$log4k", "toString", "", "log4k"})
        public static final class Daily
        extends Rotate {
            @NotNull
            public static final Daily INSTANCE = new Daily();

            private Daily() {
                super(null);
            }

            @Override
            @NotNull
            public Path logFile$log4k(@NotNull Path logPath) {
                Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
                LocalDate today = TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).getDate();
                String[] stringArray = new String[]{"log.daily." + LocalDate.Formats.INSTANCE.getISO().format((Object)today) + ".txt"};
                return PathsKt.Path((Path)logPath, (String[])stringArray);
            }

            @Override
            public void lineWritten$log4k() {
            }

            @NotNull
            public String toString() {
                return "Daily";
            }

            public int hashCode() {
                return 1363547398;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Daily)) {
                    return false;
                }
                Daily cfr_ignored_0 = (Daily)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\r\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000fJ\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001\u00a8\u0006\u0012"}, d2={"Lsaschpe/log4k/FileLogger$Rotate$Never;", "Lsaschpe/log4k/FileLogger$Rotate;", "()V", "equals", "", "other", "", "hashCode", "", "lineWritten", "", "lineWritten$log4k", "logFile", "Lkotlinx/io/files/Path;", "logPath", "logFile$log4k", "toString", "", "log4k"})
        public static final class Never
        extends Rotate {
            @NotNull
            public static final Never INSTANCE = new Never();

            private Never() {
                super(null);
            }

            @Override
            @NotNull
            public Path logFile$log4k(@NotNull Path logPath) {
                Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
                String[] stringArray = new String[]{"log.txt"};
                return PathsKt.Path((Path)logPath, (String[])stringArray);
            }

            @Override
            public void lineWritten$log4k() {
            }

            @NotNull
            public String toString() {
                return "Never";
            }

            public int hashCode() {
                return 1372914041;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Never)) {
                    return false;
                }
                Never cfr_ignored_0 = (Never)other;
                return true;
            }
        }
    }
}

