/*
 * Decompiled with CFR 0.152.
 */
package saschpe.log4k;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import saschpe.log4k.Log;
import saschpe.log4k.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\b\u0010\r\u001a\u00020\tH\u0002R\u0018\u0010\u000e\u001a\u00020\t*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0012j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lsaschpe/log4k/ConsoleLogger;", "Lsaschpe/log4k/Logger;", "<init>", "()V", "print", "", "level", "Lsaschpe/log4k/Log$Level;", "tag", "", "message", "throwable", "", "getTraceTag", "stackTraceString", "getStackTraceString", "(Ljava/lang/Throwable;)Ljava/lang/String;", "levelMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "Companion", "log4k"})
@SourceDebugExtension(value={"SMAP\nConsoleLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleLogger.kt\nsaschpe/log4k/ConsoleLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class ConsoleLogger
extends Logger {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final HashMap<Log.Level, String> levelMap;
    private static final java.util.logging.Logger javaLogger;

    public ConsoleLogger() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)Log.Level.Verbose), (Object)(Logger.AnsiColor.White.getValue() + "Verbose" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Debug), (Object)(Logger.AnsiColor.Blue.getValue() + "Debug" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Info), (Object)(Logger.AnsiColor.Green.getValue() + "Info" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Warning), (Object)(Logger.AnsiColor.Yellow.getValue() + "Warn" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Error), (Object)(Logger.AnsiColor.Red.getValue() + "Error" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Assert), (Object)(Logger.AnsiColor.Magenta.getValue() + "Assert" + Logger.AnsiColor.Reset.getValue()))};
        this.levelMap = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Override
    protected void print(@NotNull Log.Level level, @NotNull String tag, @Nullable String message, @Nullable Throwable throwable) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        CharSequence charSequence2 = tag;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = this.getTraceTag();
        } else {
            charSequence = charSequence2;
        }
        String logTag = (String)charSequence;
        Object fullMessage = null;
        fullMessage = String.valueOf(message);
        Throwable throwable2 = throwable;
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            fullMessage = fullMessage + "\n" + this.getStackTraceString(it);
        }
        String msg = this.levelMap.get((Object)level) + " " + logTag + ": " + fullMessage;
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                javaLogger.finest(msg);
                break;
            }
            case 2: {
                javaLogger.fine(msg);
                break;
            }
            case 3: {
                javaLogger.info(msg);
                break;
            }
            case 4: {
                javaLogger.warning(msg);
                break;
            }
            case 5: {
                javaLogger.severe(msg);
                break;
            }
            case 6: {
                javaLogger.severe(msg);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final String getTraceTag() {
        StackTraceElement trace = new Exception().getStackTrace()[6];
        String string = trace.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
        String[] stringArray = new String[]{"."};
        String className = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (Intrinsics.areEqual((Object)className, (Object)"NativeMethodAccessorImpl")) {
            trace = new Exception().getStackTrace()[5];
            String string2 = trace.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClassName(...)");
            stringArray = new String[]{"."};
            className = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        return className + "." + trace.getMethodName();
    }

    private final String getStackTraceString(Throwable $this$stackTraceString) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        $this$stackTraceString.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$javaLogger_u24lambda_u240_u240;
        ConsoleHandler consoleHandler;
        java.util.logging.Logger logger;
        Companion = new Companion(null);
        java.util.logging.Logger $this$javaLogger_u24lambda_u240 = logger = java.util.logging.Logger.getLogger(ConsoleLogger.class.getName());
        boolean bl = false;
        $this$javaLogger_u24lambda_u240.setLevel(Level.ALL);
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT %5$s %n");
        ConsoleHandler consoleHandler2 = consoleHandler = new ConsoleHandler();
        java.util.logging.Logger logger2 = $this$javaLogger_u24lambda_u240;
        boolean bl2 = false;
        $this$javaLogger_u24lambda_u240_u240.setLevel(Level.ALL);
        $this$javaLogger_u24lambda_u240_u240.setFormatter(new SimpleFormatter());
        logger2.addHandler(consoleHandler);
        $this$javaLogger_u24lambda_u240.setUseParentHandlers(false);
        javaLogger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lsaschpe/log4k/ConsoleLogger$Companion;", "", "<init>", "()V", "javaLogger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getJavaLogger$log4k", "()Ljava/util/logging/Logger;", "log4k"})
    public static final class Companion {
        private Companion() {
        }

        public final java.util.logging.Logger getJavaLogger$log4k() {
            return javaLogger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Log.Level.values().length];
            try {
                nArray[Log.Level.Verbose.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Log.Level.Debug.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Log.Level.Info.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Log.Level.Warning.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Log.Level.Error.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Log.Level.Assert.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

