package de.pfabulist.kleinod.crypt;

import de.pfabulist.kleinod.text.Strings;

import java.util.HashMap;
import java.util.Map;

/**
* ** BEGIN LICENSE BLOCK *****
* BSD License (2 clause)
* Copyright (c) 2006 - 2014, Stephan Pfab
* All rights reserved.
 *
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
* * Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
* * Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in the
* documentation and/or other materials provided with the distribution.
 *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* **** END LICENSE BLOCK ****
*/
public class Base16 {

    private static Map<String,Byte> toNum = new HashMap<>();

    static
    {
        synchronized( toNum ) {
            byte[] by = new byte[1];
            for ( int b = Byte.MIN_VALUE; b <= Byte.MAX_VALUE; b++ ) {
                by[0] = (byte) b;
                toNum.put( Strings.asHex(by), by[0] );
            }
        }
    }


    public String encrypt( byte[] orig ) {
        return Strings.asHex( orig );
    }

    public byte[] decrypt( String encrypted ) {
        if ( (encrypted.length() / 2)*2 < encrypted.length() ) {
            throw new IllegalArgumentException( "string's length is odd " + encrypted );
        }

        byte[] ret = new byte[encrypted.length()/2];

        for ( int i = 0; i < encrypted.length(); i += 2 ) {
            final String substring = encrypted.substring( i, i + 2 );
            if ( !toNum.containsKey( substring )) {
                throw new IllegalArgumentException( "not a base16 encoded string: " + encrypted  );
            }
            ret[i/2] = toNum.get( substring );
        }

        return ret;
    }



}
