/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.errors;

import de.pfabulist.kleinod.errors.BiFunctionE;
import de.pfabulist.kleinod.errors.ConsumerE;
import de.pfabulist.kleinod.errors.FileNotFoundRuntimeException;
import de.pfabulist.kleinod.errors.FunctionE;
import de.pfabulist.kleinod.errors.IORuntimeException;
import de.pfabulist.kleinod.errors.PredicateE;
import de.pfabulist.kleinod.errors.RunnableE;
import de.pfabulist.kleinod.errors.SupplierE;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Unchecked {
    private Unchecked() {
    }

    public static RuntimeException runtime(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof FileNotFoundException) {
            return new FileNotFoundRuntimeException((FileNotFoundException)e);
        }
        if (e instanceof IOException) {
            return new IORuntimeException((IOException)e);
        }
        return new RuntimeException(e);
    }

    public static <A> Predicate<A> predicate(PredicateE<A> f) {
        return a -> {
            try {
                return f.call(a);
            }
            catch (Exception e) {
                throw Unchecked.runtime(e);
            }
        };
    }

    public static <A, B, R> BiFunction<A, B, R> biFunction(BiFunctionE<A, B, R> f) {
        return (a, b) -> {
            try {
                return f.apply(a, b);
            }
            catch (Exception e) {
                throw Unchecked.runtime(e);
            }
        };
    }

    public static <A, R> Function<A, R> function(FunctionE<A, R> f) {
        return a -> {
            try {
                return f.apply(a);
            }
            catch (Exception e) {
                throw Unchecked.runtime(e);
            }
        };
    }

    public static <A> Consumer<A> consumer(ConsumerE<A> f) {
        return a -> {
            try {
                f.accept(a);
            }
            catch (Exception e) {
                throw Unchecked.runtime(e);
            }
        };
    }

    public static Runnable runnable(RunnableE f) {
        return () -> {
            try {
                f.run();
            }
            catch (Exception e) {
                throw Unchecked.runtime(e);
            }
        };
    }

    public static <A> Supplier<A> supplier(SupplierE<A> f) {
        return () -> {
            try {
                return f.get();
            }
            catch (Exception e) {
                throw Unchecked.runtime(e);
            }
        };
    }

    public static <T> T val(SupplierE<T> f) {
        try {
            return f.get();
        }
        catch (Exception e) {
            throw Unchecked.runtime(e);
        }
    }

    public static void statement(RunnableE f) {
        try {
            f.run();
        }
        catch (Exception e) {
            throw Unchecked.runtime(e);
        }
    }
}

