/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.paths;

import de.pfabulist.kleinod.emergent.Todo;
import de.pfabulist.kleinod.errors.Unchecked;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class PathUtils {
    public static final String DEFAULT_FILESYSTEM_SCHEME = "file";
    private static DateTimeFormatter dtf = DateTimeFormatter.ofPattern("YYYY");

    private PathUtils() {
    }

    public static Path getTmpDir(String prefix) {
        return FileSystems.getDefault().getPath(System.getProperty("java.io.tmpdir"), prefix + "-" + PathUtils.fsFriendlyName(Clock.systemUTC().instant()));
    }

    public static String fsFriendlyName(Instant inst) {
        return PathUtils.getDateTimeString(inst);
    }

    public static String getDateTimeString(Instant instant) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd--HH-mm-ss--SSS").withZone(ZoneId.systemDefault());
        return formatter.format(instant);
    }

    public static FileSystem getOrCreate(URI uri, Map<String, ?> env) throws IOException {
        if (uri.getScheme().equals(DEFAULT_FILESYSTEM_SCHEME)) {
            return FileSystems.getDefault();
        }
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException exp) {
            return FileSystems.newFileSystem(uri, env);
        }
    }

    public static Path get(URI uri, Map<String, ?> env) throws IOException {
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException e) {
            PathUtils.getOrCreate(uri, env);
            return Paths.get(uri);
        }
    }

    public static void deleteRecursive(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                Todo.todo();
            }
            return;
        }
        final ArrayList toDel = new ArrayList();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    toDel.add(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        toDel.add(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
        catch (IOException e) {
            Todo.todo();
        }
        try {
            for (Path delMe : toDel) {
                Files.delete(delMe);
            }
        }
        catch (IOException e) {
            Todo.todo();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEmpty(Path dir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            Iterator<Path> iterator = stream.iterator();
            if (iterator.hasNext()) {
                Path kid = iterator.next();
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw Unchecked.runtime(e);
        }
    }
}

