/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.errors;

import de.pfabulist.kleinod.errors.BiConsumerE;
import de.pfabulist.kleinod.errors.BiFunctionE;
import de.pfabulist.kleinod.errors.ConsumerE;
import de.pfabulist.kleinod.errors.FileNotFoundRuntimeException;
import de.pfabulist.kleinod.errors.Function3E;
import de.pfabulist.kleinod.errors.FunctionE;
import de.pfabulist.kleinod.errors.IORuntimeException;
import de.pfabulist.kleinod.errors.PredicateE;
import de.pfabulist.kleinod.errors.RunnableE;
import de.pfabulist.kleinod.errors.Runnnable;
import de.pfabulist.kleinod.errors.SupplierE;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Unchecked {
    private Unchecked() {
    }

    public static RuntimeException runtime(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof FileNotFoundException) {
            return new FileNotFoundRuntimeException((FileNotFoundException)e);
        }
        if (e instanceof IOException) {
            return new IORuntimeException((IOException)e);
        }
        return new RuntimeException(e);
    }

    public static <A, E extends Exception> Predicate<A> predicate(PredicateE<A, E> f) {
        return a -> {
            try {
                return f.call(a);
            }
            catch (Exception e) {
                throw Unchecked.runtime(e);
            }
        };
    }

    public static <A, B, R, E extends Exception> BiFunction<A, B, R> biFunction(BiFunctionE<A, B, R, E> f) {
        return (a, b) -> {
            try {
                return f.apply(a, b);
            }
            catch (Exception e) {
                throw Unchecked.runtime(e);
            }
        };
    }

    public static <A, R, E extends Exception> Function<A, R> function(FunctionE<A, R, E> f) {
        return a -> {
            try {
                return f.apply(a);
            }
            catch (Exception e) {
                throw Unchecked.runtime(e);
            }
        };
    }

    public static <A, E extends Exception> Consumer<A> consumer(ConsumerE<A, E> f) {
        return a -> {
            try {
                f.accept(a);
            }
            catch (Exception e) {
                throw Unchecked.runtime(e);
            }
        };
    }

    public static <A, B, E extends Exception> BiConsumer<A, B> biConsumer(BiConsumerE<A, B, E> f) {
        return (a, b) -> {
            try {
                f.accept(a, b);
            }
            catch (Exception e) {
                throw Unchecked.runtime(e);
            }
        };
    }

    public static <E extends Exception> Runnable runnable(RunnableE<E> f) {
        return () -> {
            try {
                f.run();
            }
            catch (Exception e) {
                throw Unchecked.runtime(e);
            }
        };
    }

    public static <A, E extends Exception> Supplier<A> supplier(SupplierE<A, E> f) {
        return () -> {
            try {
                return f.get();
            }
            catch (Exception e) {
                throw Unchecked.runtime(e);
            }
        };
    }

    public static <T, E extends Exception> T val(SupplierE<T, E> f) {
        try {
            return f.get();
        }
        catch (Exception e) {
            throw Unchecked.runtime(e);
        }
    }

    public static <A, L, R, E extends Exception> R valE1(BiFunctionE<A, L[], R, E> f, A a, L ... l) {
        try {
            return f.apply(a, l);
        }
        catch (Exception e) {
            throw Unchecked.runtime(e);
        }
    }

    public static <A, B, L, R, E extends Exception> R valE2(Function3E<A, B, L[], R, E> f, A a, B b, L ... l) {
        try {
            return f.apply(a, b, l);
        }
        catch (Exception e) {
            throw Unchecked.runtime(e);
        }
    }

    public static void statement(RunnableE f) {
        try {
            f.run();
        }
        catch (Exception e) {
            throw Unchecked.runtime(e);
        }
    }

    public static <E extends Exception> E unwrap(Class<E> exceptionClass, RuntimeException e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            throw e;
        }
        if (exceptionClass.isAssignableFrom(cause.getClass())) {
            return (E)((Exception)cause);
        }
        throw e;
    }

    public static <R, E extends Exception> R unwrap(Class<E> exceptionClass, Supplier<R> f) throws E {
        try {
            return f.get();
        }
        catch (RuntimeException e) {
            throw Unchecked.unwrap(exceptionClass, e);
        }
    }

    public static <E extends Exception> void unwrapV(Class<E> exceptionClass, Runnnable f) throws E {
        try {
            f.run();
        }
        catch (RuntimeException e) {
            throw Unchecked.unwrap(exceptionClass, e);
        }
    }
}

