/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.os;

import java.util.regex.Pattern;

public class OS {
    private static final Pattern UNIX = Pattern.compile("Linux|Mac OS X|AIX|Digital Unix|FreeBSD|HP UX|Irix|Solaris");
    private static final String WINDOWS = "Windows";
    private final String osName;

    public OS() {
        this.osName = System.getProperty("os.name");
    }

    OS(String osName) {
        this.osName = osName;
    }

    public boolean isWindows() {
        return this.osName.startsWith(WINDOWS);
    }

    public boolean isWindowsVistaPlus() {
        return this.osName.equals("Windows Vista") || this.osName.equals("Windows 7");
    }

    public boolean isLinux() {
        return this.osName.startsWith("Linux");
    }

    public boolean isOSX() {
        return this.osName.equals("Mac os X");
    }

    public boolean isUnix() {
        return UNIX.matcher(this.osName).matches();
    }
}

