package de.pfabulist.kleinod.paths;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.*;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;

import static de.pfabulist.kleinod.errors.Unchecked.runtime;

/**
* ** BEGIN LICENSE BLOCK *****
* BSD License (2 clause)
* Copyright (c) 2006 - 2015, Stephan Pfab
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
* * Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
* * Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in the
* documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* **** END LICENSE BLOCK ****
*/
public class Filess {

    private Filess() {}

    public static long size( Path path ) {
        try {
            return Files.size( path );
        } catch( IOException e ) {
            throw runtime( e );
        }
    }

    public static void delete( Path path ) {
        try {
            Files.delete( path );
        } catch( IOException e ) {
            throw runtime( e );
        }
    }

    public static Path createDirectories( Path path ) {
        try {
            return Files.createDirectories( path );
        } catch( IOException e ) {
            throw runtime( e );
        }
    }

    public static Path createDirectory( Path path, FileAttribute... attributes ) {
        try {
            return Files.createDirectory( path, attributes );
        } catch( IOException e ) {
            throw runtime( e );
        }
    }

    public static Path write( Path path, byte[] bytes, OpenOption... options ) {
        try {
            return Files.write( path, bytes, options );
        } catch( IOException e ) {
            throw runtime( e );
        }
    }

    public static byte[] readAllBytes( Path path ) {
        try {
            return Files.readAllBytes( path );
        } catch( IOException e ) {
            throw runtime( e );
        }
    }

    public static void copy( Path src, Path target, CopyOption... options ) {
        try {
            Files.copy( src, target, options );
        } catch( IOException e ) {
            throw runtime( e );
        }
    }

    public static void copy( InputStream is, Path target, CopyOption... options ) {
        try {
            Files.copy( is, target, options );
        } catch( IOException e ) {
            throw runtime( e );
        }
    }

    public static void copy( Path src, OutputStream os ) {
        try {
            Files.copy( src, os );
        } catch( IOException e ) {
            throw runtime( e );
        }
    }

    public static void deleteIfExists( Path path ) {
        try {
            Files.deleteIfExists( path );
        } catch( IOException e ) {
            throw runtime( e );
        }

    }

    public static void move( Path src, Path tgt, CopyOption... options ) {
        try {
            Files.move( src, tgt, options );
        } catch( IOException e ) {
            throw runtime( e );
        }
    }

    public static FileTime getLastModifiedTime( Path path, LinkOption... options ) {
        try {
            return Files.getLastModifiedTime( path, options );
        } catch( IOException e ) {
            throw runtime( e );
        }
    }

    public static void setLastModifiedTime( Path path, FileTime time ) {
        try {
            Files.setLastModifiedTime( path, time );
        } catch( IOException e ) {
            throw runtime( e );
        }
    }

    public static FileStore getFileStore( Path path ) {
        try {
            return Files.getFileStore( path );
        } catch( IOException e ) {
            throw runtime( e );
        }
    }

}
