/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.text;

import java.nio.charset.StandardCharsets;

public class Strings {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String aliceText = "'But who is to give the prizes?' quite a chorus of voices asked.\n'Why, SHE, of course,' said the Dodo, pointing to Alice with one finger; and the whole party at once crowded round her, calling out in a confused way, 'Prizes! Prizes!'\nAlice had no idea what to do, and in despair she put her hand in her pocket, and pulled out a box of comfits, (luckily the salt water had not got into it), and handed them round as prizes. There was exactly one a-piece all round.\n'But she must have a prize herself, you know,' said the Mouse.\n'Of course,' the Dodo replied very gravely. 'What else have you got in your pocket?' he went on, turning to Alice.\n'Only a thimble,' said Alice sadly.\n'Hand it over here,' said the Dodo.\n";

    private Strings() {
    }

    public static String toFirstLower(String name) {
        if (Strings.isEmpty(name)) {
            return name;
        }
        return "" + name.toLowerCase().charAt(0) + name.substring(1);
    }

    public static boolean isEmpty(String name) {
        return name == null || name.isEmpty();
    }

    public static String toFirstUpper(String name) {
        if (Strings.isEmpty(name)) {
            return name;
        }
        return "" + name.toUpperCase().charAt(0) + name.substring(1);
    }

    public static String asHex(byte[] hash) {
        char[] buf = new char[hash.length * 2];
        int x = 0;
        for (int i = 0; i < hash.length; ++i) {
            buf[x++] = HEX_CHARS[hash[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[hash[i] & 0xF];
        }
        return new String(buf);
    }

    public static String withoutSuffix(String in, String suffix) {
        if (in.endsWith(suffix)) {
            return in.substring(0, in.length() - suffix.length());
        }
        return in;
    }

    public static byte[] getBytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static String newString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

