//package de.pfabulist.kleinod.errors;
//
//import java.io.FileNotFoundException;
//import java.io.IOException;
//import java.util.function.*;
//
///**
// * ** BEGIN LICENSE BLOCK *****
// * BSD License (2 clause)
// * Copyright (c) 2006 - 2015, Stephan Pfab
// * All rights reserved.
// * <p>
// * Redistribution and use in source and binary forms, with or without
// * modification, are permitted provided that the following conditions are met:
// * * Redistributions of source code must retain the above copyright
// * notice, this list of conditions and the following disclaimer.
// * * Redistributions in binary form must reproduce the above copyright
// * notice, this list of conditions and the following disclaimer in the
// * documentation and/or other materials provided with the distribution.
// * <p>
// * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
// * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// * **** END LICENSE BLOCK ****
// */
//
///**
// * Wrapper for checked exceptions to be used in methods without throws
// * good for closures and slim code
// */
//public class Unchecked {
//
//    private Unchecked() {
//    }
//
//    public static RuntimeException Sneaky.sneakyThrow( Exception e ) {
//        if( e instanceof RuntimeException ) {
//            return (RuntimeException) e;
//        }
//
//        if( e instanceof FileNotFoundException ) {
//            return new FileNotFoundRuntimeException( (FileNotFoundException) e );
//        }
//
//        if( e instanceof IOException ) {
//            return new IORuntimeException( (IOException) e );
//        }
//
//        return new RuntimeException( e );
//    }
//
//    public static <A, E extends Exception> Predicate<A> predicate( PredicateE<A, E> f ) {
//        return ( A a ) -> {
//            try {
//                return f.call( a );
//            } catch( Exception e ) {
//                throw Sneaky.sneakyThrow( e );
//            }
//        };
//    }
//
//    public static <A, B, R, E extends Exception> BiFunction<A, B, R> biFunction( BiFunctionE<A, B, R, E> f ) {
//        return ( A a, B b ) -> {
//            try {
//                return f.apply( a, b );
//            } catch( Exception e ) {
//                throw Sneaky.sneakyThrow( e );
//            }
//        };
//    }
//
//    public static <A, R, E extends Exception> Function<A, R> function( FunctionE<A, R, E> f ) {
//        return ( A a ) -> {
//            try {
//                return f.apply( a );
//            } catch( Exception e ) {
//                throw Sneaky.sneakyThrow( e );
//            }
//        };
//    }
//
//    public static <A, E extends Exception> Consumer<A> consumer( ConsumerE<A, E> f ) {
//        return ( A a ) -> {
//            try {
//                f.accept( a );
//            } catch( Exception e ) {
//                throw Sneaky.sneakyThrow( e );
//            }
//        };
//    }
//
//    public static <A, B, E extends Exception> BiConsumer<A, B> biConsumer( BiConsumerE<A, B, E> f ) {
//        return ( A a, B b ) -> {
//            try {
//                f.accept( a, b );
//            } catch( Exception e ) {
//                throw Sneaky.sneakyThrow( e );
//            }
//        };
//    }
//
//    public static <E extends Exception> Runnable runnable( RunnableE<E> f ) {
//        return () -> {
//            try {
//                f.run();
//            } catch( Exception e ) {
//                throw Sneaky.sneakyThrow( e );
//            }
//        };
//    }
//
//    public static <A, E extends Exception> Supplier<A> supplier( SupplierE<A, E> f ) {
//        return () -> {
//            try {
//                return f.get();
//            } catch( Exception e ) {
//                throw Sneaky.sneakyThrow( e );
//            }
//        };
//    }
//
//    public static <T, E extends Exception> T val( SupplierE<T, E> f ) {
//        try {
//            return f.get();
//        } catch( Exception e ) {
//            throw Sneaky.sneakyThrow( e );
//        }
//    }
//
//    public static <A, L, R, E extends Exception> R valE1( BiFunctionE<A, L[], R, E> f, A a, L... l ) {
//        try {
//            return f.apply( a, l );
//        } catch( Exception e ) {
//            throw Sneaky.sneakyThrow( e );
//        }
//    }
//
//    public static <A, B, L, R, E extends Exception> R valE2( Function3E<A, B, L[], R, E> f, A a, B b, L... l ) {
//        try {
//            return f.apply( a, b, l );
//        } catch( Exception e ) {
//            throw Sneaky.sneakyThrow( e );
//        }
//    }
//
//    public static void statement( RunnableE f ) {
//        try {
//            f.run();
//        } catch( Exception e ) {
//            throw Sneaky.sneakyThrow( e );
//        }
//    }
//
//    public static <E extends Exception> E unwrap( Class<E> exceptionClass, RuntimeException e ) {
//        Throwable cause = e.getCause();
//        if( cause == null ) {
//            throw e;
//        }
//
//        if( exceptionClass.isAssignableFrom( cause.getClass() ) ) {
//            return exceptionClass.cast( cause );
//        }
//        throw e;
//    }
//
//    public static <R, E extends Exception> R unwrap( Class<E> exceptionClass, Supplier<R> f ) throws E {
//        try {
//            return f.get();
//        } catch( RuntimeException e ) {
//            throw unwrap( exceptionClass, e );
//        }
//    }
//
//}
