package de.pfabulist.kleinod.text;

import java.nio.charset.StandardCharsets;


/***** BEGIN LICENSE BLOCK *****
* BSD License (2 clause)
* Copyright (c) 2006 - 2015, Stephan Pfab
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*     * Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
***** END LICENSE BLOCK *****/


public class Strings {


    private Strings() {}

    /**
     * Make the first character lower case
     * @param name Any String
     * @return A String
     */
    public static String toFirstLower( String name ) {
        if ( isEmpty( name )) {
            return name;
        }
        return "" + name.toLowerCase().charAt(0) + name.substring(1);
    }

    /**
     * if string is null or ""
     * @param name any string
     * @return true === the is empty or null
     */
    public static boolean isEmpty(String name) {
        return name == null || name.isEmpty();
    }

    /**
     * Make the first character upper case
     * @param name Any String
     * @return A String
     */
    public static String toFirstUpper(String name) {
        if ( isEmpty( name )) {
            return name;
        }
        return "" + name.toUpperCase().charAt(0) + name.substring(1);
    }


    private static final char[] HEX_CHARS = {
        '0', '1', '2', '3',
        '4', '5', '6', '7',
        '8', '9', 'a', 'b',
        'c', 'd', 'e', 'f',};

    /**
     * Turns array of bytes into string representing each byte as
     * unsigned hex number.
     *
     * @param hash	Array of bytes to convert to hex-string
     * @return	Generated hex string
     */
    public static String asHex( byte hash[] ) {

        char buf[] = new char[hash.length * 2];

        for (int i = 0, x = 0; i < hash.length; i++) {

            buf[x++] = HEX_CHARS[(hash[i] >>> 4) & 0xf];
            buf[x++] = HEX_CHARS[hash[i] & 0xf];
        }

        return new String(buf);
    }

    public static String withoutSuffix( String in, String suffix ) {
        if ( in.endsWith( suffix )) {
            return in.substring( 0, in.length() - suffix.length() );
        }

        return in;
    }

    public static final String aliceText = "'But who is to give the prizes?' quite a chorus of voices asked.\n" +
            "'Why, SHE, of course,' said the Dodo, pointing to Alice with one finger; and the whole party at once crowded round her, calling out in a confused way, 'Prizes! Prizes!'\n" +
            "Alice had no idea what to do, and in despair she put her hand in her pocket, and pulled out a box of comfits, (luckily the salt water had not got into it), and handed them round as prizes. There was exactly one a-piece all round.\n" +
            "'But she must have a prize herself, you know,' said the Mouse.\n" +
            "'Of course,' the Dodo replied very gravely. 'What else have you got in your pocket?' he went on, turning to Alice.\n" +
            "'Only a thimble,' said Alice sadly.\n" +
            "'Hand it over here,' said the Dodo.\n";


    public static byte[] getBytes( String str ) {
        return str.getBytes( StandardCharsets.UTF_8 );
    }

    public static String newString( byte[] bytes ) {
        return new String( bytes, StandardCharsets.UTF_8 );
    }


}
