/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.os;

import java.util.regex.Pattern;

public class OS {
    private static final Pattern UNIX = Pattern.compile("Linux|Mac OS X|AIX|Digital Unix|FreeBSD|HP UX|Irix|Solaris");
    private final String osName;

    public OS() {
        this.osName = System.getProperty("os.name");
    }

    OS(String osName) {
        this.osName = osName;
    }

    public boolean isWindows() {
        return this.osName.startsWith("Windows");
    }

    public boolean isWindowsVistaPlus() {
        return "Windows Vista".equals(this.osName) || "Windows 7".equals(this.osName);
    }

    public boolean isLinux() {
        return this.osName.startsWith("Linux");
    }

    public boolean isOSX() {
        return "Mac os X".equals(this.osName);
    }

    public boolean isUnix() {
        return UNIX.matcher(this.osName).matches();
    }
}

