package de.pfabulist.kleinod.os;

import java.util.regex.Pattern;


/***** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2012, Stephan Pfab
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
***** END LICENSE BLOCK *****/


public class OS {

    private final static Pattern UNIX_PATTERN = Pattern.compile( "Mac OS X|Mac OS X Server|AIX|FreeBSD|HP UX|Irix|Solaris|HP-UX|SunOS|OSF1");


    private final String osName;

    public OS() {
        osName = System.getProperty( "os.name" );
    }

    public static final OS UNIX = new OS( "unix" );
    public static final OS WINDOWS = new OS( "windows" );
    public static final OS OSX = new OS( "Mac OS X");

    OS( String osName ) {
        this.osName = osName;
    }

    /**
     * Is this Windows ?
     * @return true iff this system is windows
     */
    public boolean isWindows() {
        return osName.startsWith("Windows");
    }


    /**
     * Is this Windows Vista or later
     * @return true iff this system is windows vista or later
     */
    public  boolean isWindowsVistaPlus() {
        return "Windows Vista".equals( osName ) || "Windows 7".equals( osName );
    }

    /**
     * Is this Linux ?
     * @return true iff this system is Linux
     */
    public boolean isLinux() {
        return osName.startsWith("Linux");
    }

    /**
     * Is this OSX ?
     * @return true iff this system is OSX
     */
    public boolean isOSX() {
        return osName.startsWith( "Mac OS X" );
    }

    /**
     * Is this Unix ?
     * @return true iff this system is Unix
     */
    public boolean isUnix() {

        return osName.contains( "nux" ) || osName.contains( "nix" ) || osName.contains( "BSD" ) ||
                UNIX_PATTERN.matcher( osName ).matches();
    }

}
