/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.paths;

import de.pfabulist.unchecked.Filess;
import de.pfabulist.unchecked.Unchecked;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;

public class Pathss {
    public static final String DEFAULT_FILESYSTEM_SCHEME = "file";

    private Pathss() {
    }

    public static Path getTmpDir(String prefix) {
        return FileSystems.getDefault().getPath(System.getProperty("java.io.tmpdir"), prefix + "-" + Pathss.fsFriendlyName(Clock.systemUTC().instant()));
    }

    public static String fsFriendlyName(Instant inst) {
        return Pathss.getDateTimeString(inst);
    }

    public static String getDateTimeString(Instant instant) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd--HH-mm-ss--SSS").withZone(ZoneId.systemDefault());
        return formatter.format(instant);
    }

    public static FileSystem getOrCreate(URI uri, Map<String, ?> env) {
        if (uri.getScheme().equals(DEFAULT_FILESYSTEM_SCHEME)) {
            return FileSystems.getDefault();
        }
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException exp) {
            try {
                return FileSystems.newFileSystem(uri, env);
            }
            catch (IOException e) {
                throw Unchecked.u((Throwable)e);
            }
        }
    }

    public static Path get(URI uri, Map<String, ?> env) {
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException e) {
            Pathss.getOrCreate(uri, env);
            return Paths.get(uri);
        }
    }

    public static Path getPath(String str, Map<String, ?> env) {
        URI uri = URI.create(str);
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("not a uri with scheme " + uri);
        }
        return Pathss.get(uri, env);
    }

    public static void deleteRecursive(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Filess.delete((Path)path);
            return;
        }
        final ArrayList toDel = new ArrayList();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    toDel.add(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        toDel.add(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
        toDel.forEach(Filess::delete);
    }

    public static void copyRecursive(final Path src, final Path target, CopyOption ... options) {
        if (!Files.exists(src, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(src, new LinkOption[0])) {
            Filess.copy((Path)src, (Path)target, (CopyOption[])new CopyOption[0]);
            return;
        }
        try {
            Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path to = target.resolve(src.relativize(file));
                    Files.copy(file, to, new CopyOption[0]);
                    Files.setLastModifiedTime(to, Files.getLastModifiedTime(src, new LinkOption[0]));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path to = target.resolve(src.relativize(dir));
                    Files.copy(dir, to, new CopyOption[0]);
                    Files.setLastModifiedTime(to, Files.getLastModifiedTime(src, new LinkOption[0]));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEmpty(Path dir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            boolean bl = !stream.iterator().hasNext();
            return bl;
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
    }

    public static boolean isRoot(Path path) {
        return path.isAbsolute() && path.getParent() == null;
    }
}

