/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.os;

import java.util.regex.Pattern;

public class OS {
    private static final Pattern UNIX_PATTERN = Pattern.compile("(Linux)|(Solaris)|(SunOS)|(HP-UX)|(AIX)|(FreeBSD)|(Irix)|(Digital Unix)|(OSF1)|(Mac OS X.*)|(.*BSD.*)|(.*nix.*)|(.*nux.*)", 2);
    private static final Pattern WINDOWS_PATTERN = Pattern.compile("windows.*", 2);
    private static final Pattern OSX_PATTERN = Pattern.compile("mac os x.*", 2);
    private static final Pattern LINUX_PATTERN = Pattern.compile(".*linux.*", 2);
    private final String osName;
    public static final OS UNIX = new OS("unix");
    public static final OS WINDOWS = new OS("windows");
    public static final OS OSX = new OS("Mac OS X");

    public OS() {
        this(System.getProperty("os.name"));
    }

    OS(String osName) {
        this.osName = osName;
    }

    public boolean isWindows() {
        return WINDOWS_PATTERN.matcher(this.osName).matches();
    }

    public boolean isLinux() {
        return LINUX_PATTERN.matcher(this.osName).matches();
    }

    public boolean isOSX() {
        return OSX_PATTERN.matcher(this.osName).matches();
    }

    public boolean isUnix() {
        return UNIX_PATTERN.matcher(this.osName).matches();
    }

    public String toString() {
        return this.osName;
    }
}

