/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.os;

import de.pfabulist.kleinod.os.OS;
import de.pfabulist.kleinod.text.Strings;

public class PathLimits {
    private final OS os;
    private static final String oneBigUnicode;
    private static final String oneOSXCount = "\uaaaa";
    private static final String oneWindowsCount;
    private static final String oneUnixCount = "a";

    public PathLimits(OS os) {
        this.os = os;
    }

    public int getMaxFilenameLength() {
        return 255;
    }

    public int filenameCount(String fname) {
        if (this.os.isOSX()) {
            return fname.length();
        }
        if (this.os.isUnix()) {
            return Strings.getBytes(fname).length;
        }
        if (this.os.isWindows()) {
            return fname.codePointCount(0, fname.length());
        }
        throw new UnsupportedOperationException("unsupported os " + this.os);
    }

    public int pathCount(String fname) {
        if (this.os.isOSX()) {
            return Strings.getBytes(fname).length;
        }
        if (this.os.isUnix()) {
            return Strings.getBytes(fname).length;
        }
        if (this.os.isWindows()) {
            return fname.codePointCount(0, fname.length());
        }
        throw new UnsupportedOperationException("unsupported os " + this.os);
    }

    public String getBigChar() {
        if (this.os.isOSX()) {
            return oneOSXCount;
        }
        if (this.os.isWindows()) {
            return oneWindowsCount;
        }
        return oneUnixCount;
    }

    public int getMaxPathLength() {
        if (this.os.isWindows()) {
            return Short.MAX_VALUE;
        }
        if (this.os.isOSX()) {
            return 1016;
        }
        if (this.os.isUnix()) {
            return 4095;
        }
        throw new UnsupportedOperationException("os not supported: " + this.os);
    }

    public boolean bigUnicodeCountsAs1() {
        return this.os.isWindows();
    }

    static {
        oneWindowsCount = oneBigUnicode = new String(Character.toChars(66560));
    }

    public static enum CharType {
        UTF8,
        UNICODE1,
        FULL_UNICODE;

    }
}

