/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Iterators {
    private Iterators() {
    }

    public static String[] words(String str) {
        return str.split("( |\t|\r|\n)+");
    }

    public static String[] lines(String str) {
        return str.split("(\n|\r)+");
    }

    public static <T> Iterator<T> makeImmutable(final Iterator<T> it) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                return it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not allowed on immutable iterator");
            }
        };
    }

    public static <T> Iterator<T> closeable(final Iterator<T> it, final BooleanSupplier isClosed) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                if (isClosed.getAsBoolean()) {
                    return false;
                }
                return it.hasNext();
            }

            @Override
            public T next() {
                return it.next();
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    public static <T> List<T> toList(Iterable<T> it) {
        ArrayList<T> ret = new ArrayList<T>();
        for (T elem : it) {
            ret.add(elem);
        }
        return ret;
    }

    public static <T> Stream<T> stream(Iterable<T> in) {
        return StreamSupport.stream(in.spliterator(), false);
    }

    public static <T> Stream<T> parallelStream(Iterable<T> in) {
        return StreamSupport.stream(in.spliterator(), true);
    }
}

