/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.collection;

import de.pfabulist.unchecked.Unchecked;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class KleinodMap<K, V> {
    private final Map<K, V> inner;

    public KleinodMap(ConcurrentMap<K, V> inner) {
        this.inner = inner;
    }

    public KleinodMap() {
        this(new ConcurrentHashMap());
    }

    public Optional<V> get(K key) {
        return Optional.ofNullable(this.inner.get(key));
    }

    public V getOrThrow(K key) {
        return this.getOrThrow(key, new IllegalArgumentException("no value for key " + key));
    }

    public V getOrThrow(K key, Exception ex) {
        V v = this.inner.get(key);
        if (v == null) {
            throw Unchecked.u((Throwable)ex);
        }
        return v;
    }

    public boolean contains(K key) {
        return this.inner.containsKey(key);
    }

    public KleinodMap<K, V> put(K key, V value) {
        this.inner.put(key, value);
        return this;
    }

    public Collection<V> values() {
        return this.inner.values();
    }

    public Collection<K> keys() {
        return this.inner.keySet();
    }

    public V compteIfAbsent(K key, Function<K, V> comp) {
        return this.inner.computeIfAbsent(key, comp);
    }
}

