/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.collection;

import de.pfabulist.kleinod.thread.Threads;
import de.pfabulist.unchecked.Unchecked;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;

public class Repeater {
    private long max = Long.MAX_VALUE;
    private Optional<Duration> delay = Optional.empty();

    public static Repeater repeat() {
        return new Repeater();
    }

    public Repeater upto(int upto) {
        this.max = upto;
        return this;
    }

    public Repeater delay(Duration dur) {
        this.delay = Optional.of(dur);
        return this;
    }

    public boolean until(Supplier<Boolean> f) {
        for (long idx = 1L; idx < this.max; ++idx) {
            if (f.get().booleanValue()) {
                return true;
            }
            this.sleep();
        }
        return false;
    }

    private void sleep() {
        this.delay.ifPresent(Threads::sleep);
    }

    public <T, E> Optional<T> untilNoThrow(Class<E> clazz, Supplier<T> f) {
        for (long idx = 0L; idx < this.max; ++idx) {
            try {
                return Optional.of(f.get());
            }
            catch (Exception e) {
                if (!clazz.isAssignableFrom(e.getClass())) {
                    throw Unchecked.u((Throwable)e);
                }
                this.sleep();
                continue;
            }
        }
        return Optional.empty();
    }
}

