package de.pfabulist.kleinod.collection;

import com.esotericsoftware.minlog.Log;
import de.pfabulist.unchecked.functiontypes.SupplierE;

import javax.annotation.Nullable;
import java.util.Map;
import java.util.Optional;

import static de.pfabulist.unchecked.Unchecked.u;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Maps {

    public static <K,T> T getOrElse( Map<K, Object> map, K key,  Class<T> clazz, SupplierE<T, Exception> supplier ) {
        @Nullable Object val = map.get( key );

        if ( val == null ) {
            return supplier._get();
        }

        if ( !clazz.isAssignableFrom( val.getClass() )) {
            Log.error( "logic error: wrong class" );
            throw new ClassCastException( "expected " + clazz + " got " + val.getClass() );
        }

        return clazz.cast( val );
    }

    public static <K,T> T getOrElseThrow( Map<K, Object> map, K key,  Class<T> clazz, SupplierE<Exception, Exception> supplier ) {
        @Nullable Object val = map.get( key );

        if ( val == null ) {
            throw u(supplier._get());
        }

        if ( !clazz.isAssignableFrom( val.getClass() )) {
            Log.error( "logic error: wrong class" );
            throw new ClassCastException( "expected " + clazz + " got " + val.getClass() );
        }

        return clazz.cast( val );
    }

    public static <K,T> Optional<T> get( Map<K, Object> map, K key, Class<T> clazz ) {
        @Nullable Object val = map.get( key );

        if ( val == null ) {
            return Optional.empty();
        }

        if ( !clazz.isAssignableFrom( val.getClass() )) {
            Log.error( "logic error: wrong class" );
            throw new ClassCastException( "expected " + clazz + " got " + val.getClass() );
        }

        return Optional.of( clazz.cast( val ));
    }
}
