package de.pfabulist.kleinod.collection;

import de.pfabulist.unchecked.functiontypes.BiFunctionE;
import de.pfabulist.unchecked.functiontypes.FunctionE;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

import javax.annotation.Nullable;

import static de.pfabulist.nonnullbydefault.NonnullCheck._nn;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class P<A, B> {

    public final A i0; // NOSONAR
    public final B i1; // NOSONAR

    public P( A i0, B i1 ) {
        this.i0 = i0;
        this.i1 = i1;
    }

    public static <A, B> P<A, B> of( A a, B b ) {
        return new P<>( a, b );
    }

    public <R> R with( BiFunctionE<A, B, R, Exception> f ) {
        return f._apply( i0, i1 );
    }

    public static <R> R until( R a, FunctionE<R, P<Boolean, R>, Exception> f ) {

        R val = a;

        while( true ) {
            P<Boolean, R> res = _nn(f.apply( val ));
            if( res.i0 ) {
                return res.i1;
            }

            val = res.i1;
        }
    }

    @Override
    @SuppressFBWarnings( "NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION" )
    public boolean equals( @Nullable Object o ) {
        if( this == o ) {
            return true;
        }
        if( o == null || getClass() != o.getClass() ) {
            return false;
        }

        P<?, ?> p = (P<?, ?>) o;

        return i0.equals( p.i0 ) && i1.equals( p.i1 );

    }

    @Override
    public int hashCode() {
        int result = i0.hashCode();
        result = 31 * result + ( i1.hashCode() );
        return result;
    }
}
