package de.pfabulist.kleinod.collection;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

import javax.annotation.Nullable;
import java.util.concurrent.atomic.AtomicReference;

import static de.pfabulist.nonnullbydefault.NonnullCheck._nn;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

/**
 * enhace AtomicReference with equals and hashCode implementation
 *
 * @param <T>
 */
@SuppressWarnings( "PMD.UseUtilityClass" ) // todo PMD bug ? equals
public class Ref<T> extends AtomicReference<T> implements Reference<T> {

    private static final long serialVersionUID = 1L;

    public Ref( T t ) {
        super( t );
    }

    @Override
    @SuppressFBWarnings( "NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION" )
    @SuppressWarnings( "PMD.ConfusingTernary" ) // generated equals, i.e. not for reading
    public boolean equals( @Nullable Object o ) {
        synchronized( this ) {

            if( this == o ) {
                return true;
            }
            if( o == null || getClass() != o.getClass() ) {
                return false;
            }

            return _get().equals( ( (Ref) o )._get() );
        }
    }

    @Override
    @SuppressWarnings( "PMD.ConfusingTernary" ) // generated, i.e. not for reading
    public int hashCode() {
        synchronized( this ) {
            return _nn( get() ).hashCode();
        }
    }

    public T _get() {
        // member of superclass may be null but not of Ref
        return _nn( get() );
    }

    public static <T> Ref<T> valueOf( T t ) {
        return new Ref<>( t );
    }
}
