package de.pfabulist.kleinod.text;

import javax.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */


public final class Strings {

    public static final String aliceText = "'But who is to give the prizes?' quite a chorus of voices asked.\n" +
            "'Why, SHE, of course,' said the Dodo, pointing to Alice with one finger; and the whole party at once crowded round her, calling out in a confused way, 'Prizes! Prizes!'\n" +
            "Alice had no idea what to do, and in despair she put her hand in her pocket, and pulled out a box of comfits, (luckily the salt water had not got into it), and handed them round as prizes. There was exactly one a-piece all round.\n" +
            "'But she must have a prize herself, you know,' said the Mouse.\n" +
            "'Of course,' the Dodo replied very gravely. 'What else have you got in your pocket?' he went on, turning to Alice.\n" +
            "'Only a thimble,' said Alice sadly.\n" +
            "'Hand it over here,' said the Dodo.\n";


    private Strings() {}

    /**
     * Make the first character lower case
     * @param name Any String
     * @return A String
     */
    public static String toFirstLower( String name ) {
        if ( isEmpty( name )) {
            return name;
        }
        return "" + name.toLowerCase( Locale.ROOT ).charAt(0) + name.substring(1);
    }

    /**
     * if string is null or ""
     * @param name any string
     * @return true === the is empty or null
     */
    public static boolean isEmpty( @Nullable String name) {
        return name == null || name.isEmpty();
    }

    /**
     * Make the first character upper case
     * @param name Any String
     * @return A String
     */
    public static String toFirstUpper(String name) {
        if ( isEmpty( name )) {
            return name;
        }
        return "" + name.toUpperCase( Locale.ROOT ).charAt(0) + name.substring(1);
    }


    public static String withoutSuffix( String in, String suffix ) {
        if ( in.endsWith( suffix )) {
            return in.substring( 0, in.length() - suffix.length() );
        }

        return in;
    }

    public static byte[] getBytes( String str ) {
        return str.getBytes( StandardCharsets.UTF_8 );
    }

    public static String newString( byte[] bytes ) {
        return new String( bytes, StandardCharsets.UTF_8 );
    }


}
