package de.pfabulist.kleinod.encode;

import java.util.HashMap;
import java.util.Map;

import static de.pfabulist.roast.NonnullCheck._nn;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public final class Base16 {

    private static final Map<String, Byte> toNum = new HashMap<>();

    private static final char[] HEX_CHARS = {
            '0', '1', '2', '3',
            '4', '5', '6', '7',
            '8', '9', 'a', 'b',
            'c', 'd', 'e', 'f', };

    private Base16() {
    }

    static {
        synchronized( toNum ) {
            byte[] by = new byte[ 1 ];
            for( int b = Byte.MIN_VALUE; b <= Byte.MAX_VALUE; b++ ) {
                by[ 0 ] = (byte) b;
                toNum.put( encode( by ), by[ 0 ] );
            }
        }
    }

    public static String encode( byte[] src ) {

        char buf[] = new char[ src.length * 2 ];

        for( int i = 0, x = 0; i < src.length; i++ ) {

            buf[ x++ ] = HEX_CHARS[ ( src[ i ] >>> 4 ) & 0xf ];
            buf[ x++ ] = HEX_CHARS[ src[ i ] & 0xf ];
        }

        return new String( buf );
    }

    public static byte[] decode( String src ) {
        if( ( src.length() / 2 ) * 2 < src.length() ) {
            throw new IllegalArgumentException( "string's length is odd " + src );
        }

        byte[] ret = new byte[ src.length() / 2 ];

        for( int i = 0; i < src.length(); i += 2 ) {
            final String substring = src.substring( i, i + 2 );

            if( !toNum.containsKey( substring ) ) {
                throw new IllegalArgumentException( "not a base16 encoded string: " + src );
            } else {
                ret[ i / 2 ] = _nn( toNum.get( substring ) );
            }
        }

        return ret;
    }

}
