package de.pfabulist.kleinod.nio;

import com.esotericsoftware.minlog.Log;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import static de.pfabulist.roast.unchecked.Unchecked.u;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public final class IO {

    private static final int EOF = -1;

    private IO() {}


    public static long copy( InputStream input, OutputStream output ) {
        return copy( input, output, new byte[ 8096 ] );
    }


    public static long copy( InputStream input, OutputStream output, byte[] buffer ) {
        long count = 0;
        int n = 0;
        try {
            while( EOF < ( n = input.read( buffer ) ) ) {
                output.write( buffer, 0, n );
                count += n;
            }
        } catch( IOException e ) {
            throw u( e );
        }

        try {
            output.flush();
        } catch( IOException e ) {
            Log.warn( "flush failed ", e );
        }

        return count;
    }

}
